/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.IExecutor;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingBuffer;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.WorkflowExecutionExtension;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.start.ActionStart;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public abstract class Workflow
extends Variables
implements IVariables,
INamedParameters,
IHasLogChannel,
ILoggingObject,
IExecutor,
IExtensionData,
IWorkflowEngine<WorkflowMeta> {
    protected static final Class<?> PKG = Workflow.class;
    private static final String CONST_WORKFLOW_FINISHED = "Workflow.Comment.WorkflowFinished";
    private static final String CONST_REASON_STARTED = "Workflow.Reason.Started";
    private static final String CONST_WORKFLOW_STARTED = "Workflow.Comment.WorkflowStarted";
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__workflow_execution_configuration__.xml";
    protected ILogChannel log;
    protected WorkflowRunConfiguration workflowRunConfiguration;
    protected LogLevel logLevel = DefaultLogLevel.getLogLevel();
    protected String containerObjectId;
    protected WorkflowMeta workflowMeta;
    protected AtomicInteger errors;
    protected IWorkflowEngine<WorkflowMeta> parentWorkflow;
    protected IPipelineEngine<PipelineMeta> parentPipeline;
    protected ILoggingObject parentLoggingObject;
    protected WorkflowTracker workflowTracker;
    protected final LinkedList<ActionResult> actionResults = new LinkedList();
    protected Date executionStartDate;
    protected Date executionEndDate;
    protected List<RowMetaAndData> sourceRows;
    protected Result result;
    protected boolean interactive;
    protected List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> executionFinishedListeners;
    protected List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> executionStartedListeners;
    protected List<IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>>> executionStoppedListeners;
    protected List<IActionListener> actionListeners;
    protected Set<ActionMeta> activeActions;
    protected INamedParameters namedParams = new NamedParameters();
    protected int maxActionsLogged;
    protected ActionMeta startActionMeta;
    protected Result startActionResult;
    protected String executingServer;
    protected String executingUser;
    protected Map<String, Object> extensionDataMap;
    protected AtomicInteger status;
    protected IHopMetadataProvider metadataProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.status = new AtomicInteger();
        this.executionStartedListeners = Collections.synchronizedList(new ArrayList());
        this.executionFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.executionStoppedListeners = Collections.synchronizedList(new ArrayList());
        this.actionListeners = new ArrayList<IActionListener>();
        this.activeActions = Collections.synchronizedSet(new HashSet());
        this.extensionDataMap = new HashMap<String, Object>();
        this.workflowTracker = new WorkflowTracker<WorkflowMeta>(this.workflowMeta);
        LinkedList<ActionResult> linkedList = this.actionResults;
        synchronized (linkedList) {
            this.actionResults.clear();
        }
        this.errors = new AtomicInteger(0);
        this.maxActionsLogged = Const.toInt((String)EnvUtil.getSystemProperty((String)"HOP_MAX_ACTIONS_LOGGED"), (int)1000);
        this.result = null;
        this.startActionMeta = null;
        this.startActionResult = null;
    }

    public Workflow(WorkflowMeta workflowMeta) {
        this(workflowMeta, null);
    }

    public Workflow(WorkflowMeta workflowMeta, ILoggingObject parentLogging) {
        this.workflowMeta = workflowMeta;
        this.parentLoggingObject = parentLogging;
        this.init();
        this.workflowTracker = new WorkflowTracker<WorkflowMeta>(workflowMeta);
        this.log = LogChannel.GENERAL;
        this.containerObjectId = UUID.randomUUID().toString();
    }

    public Workflow() {
        this.init();
        this.log = LogChannel.GENERAL;
        this.logLevel = LogLevel.BASIC;
    }

    public String toString() {
        if (this.workflowMeta == null || Utils.isEmpty((CharSequence)this.workflowMeta.getName())) {
            return super.toString();
        }
        return this.workflowMeta.getName();
    }

    @Override
    public String getWorkflowName() {
        if (this.workflowMeta == null) {
            return null;
        }
        return this.workflowMeta.getName();
    }

    private Result newResult() {
        Result r = new Result();
        r.setContainerId(this.containerObjectId);
        return r;
    }

    private Result newErrorResult() {
        Result r = this.newResult();
        r.setResult(false);
        r.setNrErrors(1L);
        return r;
    }

    /*
     * Loose catch block
     */
    @Override
    public Result startExecution() {
        block10: {
            this.log = new LogChannel((Object)this, this.parentLoggingObject, this.isGatheringMetrics(), true);
            this.logLevel = this.log.getLogLevel();
            this.executionStartDate = new Date();
            this.setStopped(false);
            this.setFinished(false);
            this.setInitialized(true);
            this.setInternalHopVariables();
            this.fireExecutionStartedListeners();
            this.result = this.executeFromStart();
            try {
                this.executionEndDate = new Date();
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowFinish.id, (Object)this);
                this.log.logBasic(BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]));
                this.fireExecutionFinishedListeners();
                HopVfs.freeUnusedResources();
            }
            catch (HopException e) {
                this.result.setNrErrors(1L);
                this.result.setResult(false);
                this.log.logError(BaseMessages.getString(PKG, (String)"Workflow.Log.ErrorExecWorkflow", (String[])new String[]{e.getMessage()}), (Throwable)e);
                this.emergencyWriteWorkflowTracker(this.result);
            }
            break block10;
            catch (Throwable je) {
                try {
                    this.log.logError(BaseMessages.getString(PKG, (String)"Workflow.Log.ErrorExecWorkflow", (String[])new String[]{je.getMessage()}), je);
                    this.result = this.newErrorResult();
                    this.addErrors(1);
                    this.emergencyWriteWorkflowTracker(this.result);
                    this.setActive(false);
                    this.setFinished(true);
                    this.setStopped(false);
                }
                catch (Throwable throwable) {
                    try {
                        this.executionEndDate = new Date();
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowFinish.id, (Object)this);
                        this.log.logBasic(BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]));
                        this.fireExecutionFinishedListeners();
                        HopVfs.freeUnusedResources();
                    }
                    catch (HopException e) {
                        this.result.setNrErrors(1L);
                        this.result.setResult(false);
                        this.log.logError(BaseMessages.getString(PKG, (String)"Workflow.Log.ErrorExecWorkflow", (String[])new String[]{e.getMessage()}), (Throwable)e);
                        this.emergencyWriteWorkflowTracker(this.result);
                    }
                    throw throwable;
                }
                try {
                    this.executionEndDate = new Date();
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowFinish.id, (Object)this);
                    this.log.logBasic(BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]));
                    this.fireExecutionFinishedListeners();
                    HopVfs.freeUnusedResources();
                }
                catch (HopException e) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Workflow.Log.ErrorExecWorkflow", (String[])new String[]{e.getMessage()}), (Throwable)e);
                    this.emergencyWriteWorkflowTracker(this.result);
                }
            }
        }
        return this.result;
    }

    private void emergencyWriteWorkflowTracker(Result res) {
        ActionResult jerFinalResult = new ActionResult(res, this.getLogChannelId(), BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]), null, null, null);
        WorkflowTracker<WorkflowMeta> finalTrack = new WorkflowTracker<WorkflowMeta>(this.getWorkflowMeta(), jerFinalResult);
        this.workflowTracker.addWorkflowTracker(finalTrack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeFromStart() throws HopException {
        try {
            ActionMeta startpoint;
            this.log.snap((IMetrics)Metrics.METRIC_WORKFLOW_START, new long[0]);
            this.setFinished(false);
            this.setStopped(false);
            HopEnvironment.setExecutionInformation(this);
            this.log.logBasic(BaseMessages.getString(PKG, (String)CONST_WORKFLOW_STARTED, (String[])new String[0]));
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowStart.id, (Object)this);
            ActionResult jerStart = new ActionResult(null, null, BaseMessages.getString(PKG, (String)CONST_WORKFLOW_STARTED, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_REASON_STARTED, (String[])new String[0]), null, null);
            this.workflowTracker.addWorkflowTracker(new WorkflowTracker<WorkflowMeta>(this.workflowMeta, jerStart));
            this.setActive(true);
            IWorkflowEngine<WorkflowMeta> syncObject = this;
            if (this.parentWorkflow != null) {
                syncObject = this.parentWorkflow;
            }
            Workflow workflow = syncObject;
            synchronized (workflow) {
                this.beginProcessing();
            }
            Result res = null;
            if (this.startActionMeta == null) {
                startpoint = this.workflowMeta.findStart();
            } else {
                startpoint = this.startActionMeta;
                res = this.startActionResult;
            }
            if (startpoint == null) {
                throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"Workflow.Log.CounldNotFindStartingPoint", (String[])new String[0]));
            }
            ActionResult jerEnd = null;
            if (startpoint.isStart()) {
                boolean isFirst = true;
                Result inputRes = null;
                inputRes = this.result != null ? this.result : this.newResult();
                if (this.getSourceRows() != null) {
                    inputRes.setRows(this.getSourceRows());
                }
                ActionStart jes = (ActionStart)startpoint.getAction();
                while ((jes.isRepeat() || isFirst) && !this.isStopped()) {
                    isFirst = false;
                    res = this.executeFromStart(0, inputRes, startpoint, null, BaseMessages.getString(PKG, (String)CONST_REASON_STARTED, (String[])new String[0]));
                }
                jerEnd = new ActionResult(res, jes.getLogChannelId(), BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]), BaseMessages.getString(PKG, (String)"Workflow.Reason.Finished", (String[])new String[0]), null, null);
            } else {
                res = this.executeFromStart(0, res, startpoint, null, BaseMessages.getString(PKG, (String)CONST_REASON_STARTED, (String[])new String[0]));
                jerEnd = new ActionResult(res, startpoint.getAction().getLogChannel().getLogChannelId(), BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]), BaseMessages.getString(PKG, (String)"Workflow.Reason.Finished", (String[])new String[0]), null, null);
            }
            this.workflowTracker.addWorkflowTracker(new WorkflowTracker<WorkflowMeta>(this.workflowMeta, jerEnd));
            this.setActive(false);
            if (!this.isStopped()) {
                this.setFinished(true);
            }
            Result result = res;
            return result;
        }
        finally {
            this.log.snap((IMetrics)Metrics.METRIC_WORKFLOW_STOP, new long[0]);
        }
    }

    public Result executeFromStart(int nr, Result result) throws HopException {
        Result res;
        ActionMeta startpoint;
        this.setFinished(false);
        this.setActive(true);
        this.setInitialized(true);
        HopEnvironment.setExecutionInformation(this);
        if (this.getSourceRows() != null) {
            result.setRows(this.getSourceRows());
        }
        if ((startpoint = this.workflowMeta.findStart()) == null) {
            throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"Workflow.Log.CounldNotFindStartingPoint", (String[])new String[0]));
        }
        ActionStart jes = (ActionStart)startpoint.getAction();
        do {
            res = this.executeFromStart(nr, result, startpoint, null, BaseMessages.getString(PKG, (String)"Workflow.Reason.StartOfAction", (String[])new String[0]));
            this.setActive(false);
        } while (jes.isRepeat() && !this.isStopped());
        return res;
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void addWorkflowStartedListener(IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        this.addExecutionStartedListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStartedListener(IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStartedListener(IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.remove(listener);
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void fireWorkflowStartedListeners() throws HopException {
        this.fireExecutionStartedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> listener : this.executionStartedListeners) {
                listener.started(this);
            }
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void addWorkflowFinishedListener(IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        this.addExecutionFinishedListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionFinishedListener(IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionFinishedListener(IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.remove(listener);
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void fireWorkflowFinishListeners() throws HopException {
        this.fireExecutionFinishedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionFinishedListeners() throws HopException {
        List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            for (IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> listener : this.executionFinishedListeners) {
                listener.finished(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStoppedListener(IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStoppedListener(IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>> listener) {
        List<IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStoppedListeners() {
        List<IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            for (IExecutionStoppedListener<IWorkflowEngine<WorkflowMeta>> listener : this.executionStoppedListeners) {
                listener.stopped(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeFromStart(int nr, Result previousResult, ActionMeta actionMeta, ActionMeta previous, String reason) throws HopException {
        int i;
        Result newResult;
        Result res = null;
        if (this.isStopped()) {
            res = this.newResult();
            res.setEntryNr((long)nr);
            res.setStopped(true);
            return res;
        }
        Result prevResult = null;
        prevResult = previousResult != null ? previousResult.clone() : this.newResult();
        WorkflowExecutionExtension extension = new WorkflowExecutionExtension(this, prevResult, actionMeta, true);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowBeforeActionExecution.id, (Object)extension);
        if (extension.result != null) {
            prevResult = extension.result;
        }
        if (!extension.executeAction) {
            newResult = prevResult;
        } else {
            if (this.log.isDetailed()) {
                this.log.logDetailed("exec(" + nr + ", " + (prevResult != null ? prevResult.getNrErrors() : 0L) + ", " + (actionMeta != null ? actionMeta.toString() : "null") + ")");
            }
            IAction action = actionMeta.getAction();
            action.getLogChannel().setLogLevel(this.logLevel);
            ActionResult jerBefore = new ActionResult(null, null, BaseMessages.getString(PKG, (String)CONST_WORKFLOW_STARTED, (String[])new String[0]), reason, actionMeta.getName(), this.resolve(actionMeta.getAction().getFilename()));
            this.workflowTracker.addWorkflowTracker(new WorkflowTracker<WorkflowMeta>(this.workflowMeta, jerBefore));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(action.getClass().getClassLoader());
            IAction cloneJei = (IAction)action.clone();
            cloneJei.copyFrom(this);
            cloneJei.getLogChannel().setLogLevel(this.getLogLevel());
            cloneJei.setMetadataProvider(this.metadataProvider);
            cloneJei.setParentWorkflow(this);
            cloneJei.setParentWorkflowMeta(this.getWorkflowMeta());
            long start = System.currentTimeMillis();
            cloneJei.getLogChannel().logDetailed("Starting action");
            for (IActionListener actionListener : this.actionListeners) {
                actionListener.beforeExecution(this, actionMeta, cloneJei);
            }
            if (this.interactive) {
                this.getActiveActions().add(actionMeta.clone());
            }
            this.log.snap((IMetrics)Metrics.METRIC_ACTION_START, cloneJei.toString(), new long[0]);
            newResult = cloneJei.execute(prevResult, nr);
            this.log.snap((IMetrics)Metrics.METRIC_ACTION_STOP, cloneJei.toString(), new long[0]);
            newResult.setElapsedTimeMillis(System.currentTimeMillis() - start);
            if (this.interactive) {
                this.getActiveActions().remove(actionMeta);
            }
            for (IActionListener actionListener : this.actionListeners) {
                actionListener.afterExecution(this, actionMeta, cloneJei, newResult);
            }
            Thread.currentThread().setContextClassLoader(cl);
            this.addErrors((int)newResult.getNrErrors());
            LoggingBuffer loggingBuffer = HopLogStore.getAppender();
            StringBuffer logTextBuffer = loggingBuffer.getBuffer(cloneJei.getLogChannel().getLogChannelId(), false);
            newResult.setLogText(logTextBuffer.toString() + newResult.getLogText());
            ActionResult jerAfter = new ActionResult(newResult, cloneJei.getLogChannel().getLogChannelId(), BaseMessages.getString(PKG, (String)CONST_WORKFLOW_FINISHED, (String[])new String[0]), null, actionMeta.getName(), this.resolve(actionMeta.getAction().getFilename()));
            this.workflowTracker.addWorkflowTracker(new WorkflowTracker<WorkflowMeta>(this.workflowMeta, jerAfter));
            LinkedList<ActionResult> linkedList = this.actionResults;
            synchronized (linkedList) {
                this.actionResults.add(jerAfter);
                if (this.maxActionsLogged > 0) {
                    while (this.actionResults.size() > this.maxActionsLogged) {
                        this.actionResults.removeFirst();
                    }
                }
            }
        }
        extension = new WorkflowExecutionExtension(this, prevResult, actionMeta, extension.executeAction);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowAfterActionExecution.id, (Object)extension);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        ConcurrentLinkedQueue threadResults = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue<HopException> threadExceptions = new ConcurrentLinkedQueue<HopException>();
        ArrayList<ActionMeta> threadActions = new ArrayList<ActionMeta>();
        int nrNext = this.workflowMeta.findNrNextActions(actionMeta);
        for (i = 0; i < nrNext && !this.isStopped(); ++i) {
            ActionMeta nextAction = this.workflowMeta.findNextAction(actionMeta, i);
            WorkflowHopMeta hi = this.workflowMeta.findWorkflowHop(actionMeta, nextAction);
            String nextComment = hi.isUnconditional() ? BaseMessages.getString(PKG, (String)"Workflow.Comment.FollowedUnconditional", (String[])new String[0]) : (newResult.getResult() ? BaseMessages.getString(PKG, (String)"Workflow.Comment.FollowedSuccess", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"Workflow.Comment.FollowedFailure", (String[])new String[0]));
            if (!hi.isUnconditional() && (!actionMeta.isEvaluation() || hi.isEvaluation() != newResult.getResult())) continue;
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Workflow.Log.StartingAction", (String[])new String[]{nextAction.getName()}));
            }
            if (nextAction.resetErrorsBeforeExecution()) {
                newResult.setNrErrors(0L);
            }
            if (actionMeta.isLaunchingInParallel()) {
                threadActions.add(nextAction);
                Runnable runnable = () -> {
                    try {
                        Result threadResult = this.executeFromStart(nr + 1, newResult, nextAction, actionMeta, nextComment);
                        threadResults.add(threadResult);
                    }
                    catch (Throwable e) {
                        this.log.logError(Const.getStackTracker((Throwable)e));
                        threadExceptions.add(new HopException(BaseMessages.getString(PKG, (String)"Workflow.Log.UnexpectedError", (String[])new String[]{nextAction.toString()}), e));
                        Result threadResult = this.newErrorResult();
                        threadResults.add(threadResult);
                    }
                };
                Thread thread = new Thread(runnable);
                threads.add(thread);
                thread.start();
                if (!this.log.isBasic()) continue;
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Workflow.Log.LaunchedActionInParallel", (String[])new String[]{nextAction.getName()}));
                continue;
            }
            try {
                res = this.executeFromStart(nr + 1, newResult, nextAction, actionMeta, nextComment);
            }
            catch (Throwable e) {
                this.log.logError(Const.getStackTracker((Throwable)e));
                throw new HopException(BaseMessages.getString(PKG, (String)"Workflow.Log.UnexpectedError", (String[])new String[]{nextAction.toString()}), e);
            }
            if (!this.log.isBasic()) continue;
            this.log.logBasic(BaseMessages.getString(PKG, (String)"Workflow.Log.FinishedAction", (String[])new String[]{nextAction.getName(), "" + res.getResult()}));
        }
        if (actionMeta.isLaunchingInParallel()) {
            for (i = 0; i < threads.size(); ++i) {
                Thread thread = (Thread)threads.get(i);
                ActionMeta nextAction = (ActionMeta)threadActions.get(i);
                try {
                    thread.join();
                    continue;
                }
                catch (InterruptedException e) {
                    this.log.logError(this.workflowMeta.toString(), new Object[]{BaseMessages.getString(PKG, (String)"Workflow.Log.UnexpectedErrorWhileWaitingForAction", (String[])new String[]{nextAction.getName()})});
                    threadExceptions.add(new HopException(BaseMessages.getString(PKG, (String)"Workflow.Log.UnexpectedErrorWhileWaitingForAction", (String[])new String[]{nextAction.getName()}), (Throwable)e));
                }
            }
        }
        if (res == null) {
            res = prevResult;
        }
        if (!threadExceptions.isEmpty()) {
            res.setResult(false);
            res.setNrErrors((long)threadExceptions.size());
            for (HopException e : threadExceptions) {
                this.log.logError(this.workflowMeta.toString(), new Object[]{e.getMessage(), e});
            }
            throw (HopException)((Object)threadExceptions.poll());
        }
        for (Result threadResult : threadResults) {
            res.add(threadResult);
        }
        if (res.getNrErrors() > 0L) {
            res.setResult(false);
        }
        return res;
    }

    public int getErrors() {
        return this.errors.get();
    }

    public void resetErrors() {
        this.errors.set(0);
    }

    public void addErrors(int nrToAdd) {
        if (nrToAdd > 0) {
            this.errors.addAndGet(nrToAdd);
        }
    }

    public boolean beginProcessing() throws HopException {
        this.resetErrors();
        WorkflowExecutionExtension extension = new WorkflowExecutionExtension(this, this.result, null, false);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.WorkflowBeginProcessing.id, (Object)extension);
        return true;
    }

    @Override
    public boolean isInitialized() {
        int exist = this.status.get() & BitMaskStatus.INITIALIZED.mask;
        return exist != 0;
    }

    protected void setInitialized(boolean initialized) {
        this.status.updateAndGet(v -> initialized ? v | BitMaskStatus.INITIALIZED.mask : (0x3F ^ BitMaskStatus.INITIALIZED.mask) & v);
    }

    @Override
    public boolean isActive() {
        int exist = this.status.get() & BitMaskStatus.ACTIVE.mask;
        return exist != 0;
    }

    protected void setActive(boolean active) {
        this.status.updateAndGet(v -> active ? v | BitMaskStatus.ACTIVE.mask : (0x3F ^ BitMaskStatus.ACTIVE.mask) & v);
    }

    @Override
    public boolean isStopped() {
        boolean stopped;
        int exist = this.status.get() & BitMaskStatus.STOPPED.mask;
        boolean bl = stopped = exist != 0;
        if (this.parentWorkflow != null && this.parentWorkflow.isStopped()) {
            stopped = true;
        }
        if (this.parentPipeline != null && this.parentPipeline.isStopped()) {
            stopped = true;
        }
        return stopped;
    }

    @Override
    public void stopExecution() {
        this.setStopped(true);
        this.log.logBasic(BaseMessages.getString(PKG, (String)"Workflow.Log.StopWorkflowExecution", (String[])new String[0]));
        this.fireExecutionStoppedListeners();
    }

    @Override
    public void setStopped(boolean stopped) {
        this.status.updateAndGet(v -> stopped ? v | BitMaskStatus.STOPPED.mask : (0x3F ^ BitMaskStatus.STOPPED.mask) & v);
    }

    @Override
    public boolean isFinished() {
        int exist = this.status.get() & BitMaskStatus.FINISHED.mask;
        return exist != 0;
    }

    @Override
    public void setFinished(boolean finished) {
        this.status.updateAndGet(v -> finished ? v | BitMaskStatus.FINISHED.mask : (0x3F ^ BitMaskStatus.FINISHED.mask) & v);
    }

    @Override
    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    @Override
    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    @Override
    public WorkflowTracker getWorkflowTracker() {
        return this.workflowTracker;
    }

    public void setWorkflowTracker(WorkflowTracker workflowTracker) {
        this.workflowTracker = workflowTracker;
    }

    public List<RowMetaAndData> getSourceRows() {
        return this.sourceRows;
    }

    @Override
    public void setSourceRows(List<RowMetaAndData> sourceRows) {
        this.sourceRows = sourceRows;
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    @Override
    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
        if (parentWorkflow != null) {
            this.logLevel = parentWorkflow.getLogLevel();
        }
        if (this.log != null) {
            this.log.setLogLevel(this.logLevel);
            this.containerObjectId = this.log.getContainerObjectId();
        }
    }

    public IVariables getParentVariables() {
        if (this.getParentPipeline() != null) {
            return this.getParentPipeline();
        }
        if (this.getParentWorkflow() != null) {
            return this.getParentWorkflow();
        }
        return super.getParentVariables();
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public void setResult(Result result) {
        this.result = result;
    }

    @Override
    public void setInternalHopVariables() {
        if (this.workflowMeta == null) {
            Workflow.setInternalHopVariables(this, null, null);
        } else {
            this.workflowMeta.setInternalHopVariables(this);
        }
        this.setVariable("Internal.Workflow.ID", this.log != null ? this.log.getLogChannelId() : null);
        if (this.parentLoggingObject != null) {
            this.setVariable("Internal.Workflow.ParentID", this.parentLoggingObject.getLogChannelId());
        } else {
            this.setVariable("Internal.Workflow.ParentID", null);
        }
    }

    public static final void setInternalHopVariables(IVariables variables, String filename, String name) {
        boolean hasFilename;
        boolean bl = hasFilename = !Utils.isEmpty((CharSequence)filename);
        if (hasFilename) {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)filename);
                FileName fileName = fileObject.getName();
                variables.setVariable("Internal.Workflow.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                variables.setVariable("Internal.Workflow.Filename.Folder", fileDir.getURI());
            }
            catch (Exception e) {
                variables.setVariable("Internal.Workflow.Filename.Folder", "");
                variables.setVariable("Internal.Workflow.Filename.Name", "");
            }
        } else {
            variables.setVariable("Internal.Workflow.Filename.Folder", "");
            variables.setVariable("Internal.Workflow.Filename.Name", "");
        }
        variables.setVariable("Internal.Workflow.Name", Const.NVL((String)name, (String)""));
    }

    @Override
    public String getStatusDescription() {
        Object message;
        if (this.isActive()) {
            message = this.isStopped() ? "Halting" : "Running";
        } else if (this.isFinished()) {
            message = "Finished";
            if (this.getResult().getNrErrors() > 0L) {
                message = (String)message + " (with errors)";
            }
        } else if (this.isStopped()) {
            message = "Stopped";
            if (this.getResult().getNrErrors() > 0L) {
                message = (String)message + " (with errors)";
            }
        } else {
            message = "Waiting";
        }
        return message;
    }

    @Override
    public void addActionListener(IActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(IActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    @Override
    public List<IActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public void clearParameterValues() {
        this.namedParams.clearParameterValues();
    }

    public void activateParameters(IVariables variables) {
        this.namedParams.activateParameters(variables);
    }

    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        this.namedParams.copyParametersFromDefinitions(definitions);
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.log;
    }

    public String getObjectName() {
        return this.getWorkflowName();
    }

    public String getObjectCopy() {
        return null;
    }

    public String getFilename() {
        if (this.workflowMeta == null) {
            return null;
        }
        return this.workflowMeta.getFilename();
    }

    public String getLogChannelId() {
        return this.log == null ? null : this.log.getLogChannelId();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.WORKFLOW;
    }

    public ILoggingObject getParent() {
        return this.parentLoggingObject;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        if (this.log != null) {
            this.log.setLogLevel(logLevel);
        }
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public Set<ActionMeta> getActiveActions() {
        return this.activeActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActionResult> getActionResults() {
        LinkedList<ActionResult> linkedList = this.actionResults;
        synchronized (linkedList) {
            return new ArrayList<ActionResult>(this.actionResults);
        }
    }

    @Override
    public String getContainerId() {
        return this.containerObjectId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerObjectId = containerId;
    }

    public ILoggingObject getParentLoggingObject() {
        return this.parentLoggingObject;
    }

    public void setParentLoggingObject(ILoggingObject parentLoggingObject) {
        this.parentLoggingObject = parentLoggingObject;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public ActionMeta getStartActionMeta() {
        return this.startActionMeta;
    }

    @Override
    public void setStartActionMeta(ActionMeta actionMeta) {
        this.startActionMeta = actionMeta;
    }

    @Override
    public String getExecutingServer() {
        if (this.executingServer == null) {
            this.setExecutingServer(Const.getHostname());
        }
        return this.executingServer;
    }

    @Override
    public void setExecutingServer(String executingServer) {
        this.executingServer = executingServer;
    }

    @Override
    public String getExecutingUser() {
        return this.executingUser;
    }

    @Override
    public void setExecutingUser(String executingUser) {
        this.executingUser = executingUser;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    @Override
    public IPipelineEngine<PipelineMeta> getParentPipeline() {
        return this.parentPipeline;
    }

    @Override
    public void setParentPipeline(IPipelineEngine<PipelineMeta> parentPipeline) {
        this.parentPipeline = parentPipeline;
    }

    @Override
    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    public Result getStartActionResult() {
        return this.startActionResult;
    }

    public void setStartActionResult(Result startActionResult) {
        this.startActionResult = startActionResult;
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> getWorkflowFinishedListeners() {
        return this.executionFinishedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setWorkflowFinishedListeners(List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> workflowFinishedListeners) {
        this.executionFinishedListeners = workflowFinishedListeners;
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> getWorkflowStartedListeners() {
        return this.executionStartedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setWorkflowStartedListeners(List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> workflowStartedListeners) {
        this.executionStartedListeners = workflowStartedListeners;
    }

    @Override
    public WorkflowRunConfiguration getWorkflowRunConfiguration() {
        return this.workflowRunConfiguration;
    }

    @Override
    public void setWorkflowRunConfiguration(WorkflowRunConfiguration workflowRunConfiguration) {
        this.workflowRunConfiguration = workflowRunConfiguration;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    static enum BitMaskStatus {
        ACTIVE(1),
        INITIALIZED(2),
        STOPPED(4),
        FINISHED(8);

        private final int mask;
        public static final int BIT_STATUS_SUM = 63;

        private BitMaskStatus(int mask) {
            this.mask = mask;
        }
    }
}

