/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.SvgGc;
import org.apache.hop.core.svg.HopSvgGraphics2D;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainter;

public class PipelineSvgPainter {
    public static final String generatePipelineSvg(PipelineMeta pipelineMeta, float magnification, IVariables variables) throws HopException {
        return PipelineSvgPainter.generatePipelineSvg(pipelineMeta, magnification, variables, new DPoint(0.0, 0.0), 1.0f);
    }

    public static final String generatePipelineSvg(PipelineMeta pipelineMeta, float magnification, IVariables variables, DPoint offset, float zoomFactor) throws HopException {
        try {
            Point maximum = pipelineMeta.getMaximum();
            maximum.multiply(magnification);
            HopSvgGraphics2D graphics2D = HopSvgGraphics2D.newDocument();
            SvgGc gc = new SvgGc(graphics2D, new Point(maximum.x + 100, maximum.y + 100), 32, 0, 0);
            PipelinePainter pipelinePainter = new PipelinePainter(gc, variables, pipelineMeta, maximum, offset, null, null, new ArrayList<AreaOwner>(), 32, 1, 0, "Arial", 10, zoomFactor, false, null, new HashMap<String, Object>());
            pipelinePainter.setMagnification(magnification);
            pipelinePainter.drawPipelineImage();
            return graphics2D.toXml();
        }
        catch (Exception e) {
            throw new HopException("Unable to generate SVG for pipeline " + pipelineMeta.getName(), (Throwable)e);
        }
    }
}

