/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.partition;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="partition", name="i18n::PartitionSchema.name", description="i18n::PartitionSchema.description", image="ui/images/partition_schema.svg", documentationUrl="/metadata-types/partition-schema.html")
public class PartitionSchema
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    @HopMetadataProperty
    private List<String> partitionIDs;
    @HopMetadataProperty
    private boolean dynamicallyDefined;
    @HopMetadataProperty
    private String numberOfPartitions;

    public PartitionSchema() {
        this.dynamicallyDefined = true;
        this.numberOfPartitions = "4";
        this.partitionIDs = new ArrayList<String>();
    }

    public PartitionSchema(String name, List<String> partitionIDs) {
        this.name = name;
        this.partitionIDs = partitionIDs;
    }

    public Object clone() {
        PartitionSchema partitionSchema = new PartitionSchema();
        partitionSchema.replaceMeta(this);
        return partitionSchema;
    }

    public void replaceMeta(PartitionSchema partitionSchema) {
        this.name = partitionSchema.name;
        this.partitionIDs = new ArrayList<String>();
        this.partitionIDs.addAll(partitionSchema.partitionIDs);
        this.dynamicallyDefined = partitionSchema.dynamicallyDefined;
        this.numberOfPartitions = partitionSchema.numberOfPartitions;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.name == null) {
            return false;
        }
        return this.name.equals(((PartitionSchema)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public List<String> calculatePartitionIds(IVariables variables) {
        int nrPartitions = Const.toInt((String)variables.resolve(this.numberOfPartitions), (int)0);
        if (this.dynamicallyDefined) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < nrPartitions; ++i) {
                list.add("Partition-" + (i + 1));
            }
            return list;
        }
        return this.partitionIDs;
    }

    public List<String> getPartitionIDs() {
        return this.partitionIDs;
    }

    public void setPartitionIDs(List<String> partitionIDs) {
        this.partitionIDs = partitionIDs;
    }

    public boolean isDynamicallyDefined() {
        return this.dynamicallyDefined;
    }

    public void setDynamicallyDefined(boolean dynamicallyDefined) {
        this.dynamicallyDefined = dynamicallyDefined;
    }

    public String getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(String numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }
}

