/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.util.prefs.Preferences;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.FunctorException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Assert;
import org.apache.hop.core.util.IPluginProperty;
import org.apache.hop.core.util.KeyValueSet;
import org.w3c.dom.Node;

public final class PluginPropertyHandler {
    private static final String CONST_NODE_CANNOT_BE_NULL = "Node cannot be null";

    public static void assertProperties(KeyValueSet properties) throws IllegalArgumentException {
        Assert.assertNotNull(properties, "Properties cannot be null");
    }

    public static String toXml(KeyValueSet properties) throws IllegalArgumentException {
        PluginPropertyHandler.assertProperties(properties);
        AppendXml handler = new AppendXml();
        properties.walk(handler);
        return handler.getXml();
    }

    public static void walk(KeyValueSet properties, Closure handler) throws HopException, IllegalArgumentException {
        PluginPropertyHandler.assertProperties(properties);
        try {
            properties.walk(handler);
        }
        catch (FunctorException e) {
            throw (HopException)e.getCause();
        }
    }

    private PluginPropertyHandler() {
    }

    public static class AppendXml
    extends AbstractHandler {
        private final StringBuilder builder = new StringBuilder();

        @Override
        protected void handle(IPluginProperty property) {
            property.appendXml(this.builder);
        }

        public String getXml() {
            return this.builder.toString();
        }
    }

    public static class ReadFromPreferences
    extends AbstractHandler {
        private final Preferences node;

        public ReadFromPreferences(Preferences node) throws IllegalArgumentException {
            Assert.assertNotNull(node, PluginPropertyHandler.CONST_NODE_CANNOT_BE_NULL);
            this.node = node;
        }

        @Override
        protected void handle(IPluginProperty property) {
            property.readFromPreferences(this.node);
        }
    }

    public static class SaveToPreferences
    extends AbstractHandler {
        private final Preferences node;

        public SaveToPreferences(Preferences node) throws IllegalArgumentException {
            Assert.assertNotNull(node, PluginPropertyHandler.CONST_NODE_CANNOT_BE_NULL);
            this.node = node;
        }

        @Override
        protected void handle(IPluginProperty property) {
            property.saveToPreferences(this.node);
        }
    }

    public static class LoadXml
    extends AbstractHandler {
        private final Node node;

        public LoadXml(Node node) throws IllegalArgumentException {
            Assert.assertNotNull(node, PluginPropertyHandler.CONST_NODE_CANNOT_BE_NULL);
            this.node = node;
        }

        @Override
        protected void handle(IPluginProperty property) {
            property.loadXml(this.node);
        }
    }

    public static class Fail
    extends AbstractHandler {
        public static final String MESSAGE = "Forced exception";
        public static final Fail INSTANCE = new Fail();

        @Override
        protected void handle(IPluginProperty property) throws HopException {
            throw new HopException(MESSAGE);
        }
    }

    public static abstract class AbstractHandler
    implements Closure {
        public final void execute(Object property) throws IllegalArgumentException, FunctorException {
            Assert.assertNotNull(property, "Plugin property cannot be null");
            try {
                this.handle((IPluginProperty)property);
            }
            catch (HopException e) {
                throw new FunctorException("EXCEPTION: " + this, (Throwable)e);
            }
        }

        protected abstract void handle(IPluginProperty var1) throws HopException;
    }
}

