/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.base.Ticker;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.common.collect.Lists;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Server;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@NotThreadSafe
public final class GrpcCleanupRule
extends ExternalResource {
    private final List<Resource> resources = new ArrayList<Resource>();
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private Stopwatch stopwatch = Stopwatch.createUnstarted();
    private boolean abruptShutdown;

    public GrpcCleanupRule setTimeout(long timeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeout > 0L, "timeout should be positive");
        this.timeoutNanos = timeUnit.toNanos(timeout);
        return this;
    }

    @VisibleForTesting
    GrpcCleanupRule setTicker(Ticker ticker) {
        this.stopwatch = Stopwatch.createUnstarted(ticker);
        return this;
    }

    public <T extends ManagedChannel> T register(@Nonnull T channel) {
        Preconditions.checkNotNull(channel, "channel");
        this.register(new ManagedChannelResource(channel));
        return channel;
    }

    public <T extends Server> T register(@Nonnull T server) {
        Preconditions.checkNotNull(server, "server");
        this.register(new ServerResource(server));
        return server;
    }

    @VisibleForTesting
    void register(Resource resource) {
        this.resources.add(resource);
    }

    public Statement apply(final Statement base, Description description) {
        return super.apply(new Statement(){

            public void evaluate() throws Throwable {
                GrpcCleanupRule.this.abruptShutdown = false;
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    GrpcCleanupRule.this.abruptShutdown = true;
                    throw t;
                }
            }
        }, description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        this.stopwatch.reset();
        this.stopwatch.start();
        InterruptedException interrupted = null;
        if (!this.abruptShutdown) {
            for (Resource resource : Lists.reverse(this.resources)) {
                resource.cleanUp();
            }
            for (int i = this.resources.size() - 1; i >= 0; --i) {
                try {
                    boolean released = this.resources.get(i).awaitReleased(this.timeoutNanos - this.stopwatch.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    if (!released) continue;
                    this.resources.remove(i);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    interrupted = e;
                    break;
                }
            }
        }
        if (!this.resources.isEmpty()) {
            for (Resource resource : Lists.reverse(this.resources)) {
                resource.forceCleanUp();
            }
            try {
                if (interrupted != null) {
                    throw new AssertionError("Thread interrupted before resources gracefully released", interrupted);
                }
                if (!this.abruptShutdown) {
                    throw new AssertionError((Object)("Resources could not be released in time at the end of test: " + this.resources));
                }
            }
            finally {
                this.resources.clear();
            }
        }
    }

    private static final class ServerResource
    implements Resource {
        final Server server;

        ServerResource(Server server) {
            this.server = server;
        }

        @Override
        public void cleanUp() {
            this.server.shutdown();
        }

        @Override
        public void forceCleanUp() {
            this.server.shutdownNow();
        }

        @Override
        public boolean awaitReleased(long duration, TimeUnit timeUnit) throws InterruptedException {
            return this.server.awaitTermination(duration, timeUnit);
        }

        public String toString() {
            return this.server.toString();
        }
    }

    private static final class ManagedChannelResource
    implements Resource {
        final ManagedChannel channel;

        ManagedChannelResource(ManagedChannel channel) {
            this.channel = channel;
        }

        @Override
        public void cleanUp() {
            this.channel.shutdown();
        }

        @Override
        public void forceCleanUp() {
            this.channel.shutdownNow();
        }

        @Override
        public boolean awaitReleased(long duration, TimeUnit timeUnit) throws InterruptedException {
            return this.channel.awaitTermination(duration, timeUnit);
        }

        public String toString() {
            return this.channel.toString();
        }
    }

    @VisibleForTesting
    static interface Resource {
        public void cleanUp();

        public void forceCleanUp();

        public boolean awaitReleased(long var1, TimeUnit var3) throws InterruptedException;
    }
}

