/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.util;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPIconImpl;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPServiceImpl;
import org.cybergarage.upnp.Device;
import org.cybergarage.upnp.DeviceList;
import org.cybergarage.upnp.IconList;
import org.cybergarage.upnp.Service;
import org.cybergarage.upnp.ServiceList;

public class DeviceSetup {
    public static void deviceSetup(Dictionary properties, Device dev, Vector icons, Hashtable services) {
        int i;
        DeviceList devList = dev.getDeviceList();
        if (devList.size() > 0) {
            String[] childrenUDN = new String[devList.size()];
            for (i = 0; i < devList.size(); ++i) {
                childrenUDN[i] = devList.getDevice(i).getUDN();
            }
            properties.put("UPnP.device.childrenUDN", childrenUDN);
        }
        properties.put("DEVICE_CATEGORY", new String[]{"UPnP"});
        properties.put("UPnP.device.imported", "http://felix.apache.org");
        properties.put("UPnP.device.friendlyName", dev.getFriendlyName());
        properties.put("UPnP.device.manufacturer", dev.getManufacture());
        properties.put("UPnP.device.manufacturerURL", dev.getManufactureURL());
        properties.put("UPnP.device.modelDescription", dev.getModelDescription());
        properties.put("UPnP.device.modelName", dev.getModelName());
        properties.put("UPnP.device.modelNumber", dev.getModelNumber());
        properties.put("UPnP.device.modelURL", dev.getModelURL());
        if (!dev.isRootDevice()) {
            Device parent = dev.getParentDevice();
            properties.put("UPnP.device.parentUDN", parent.getUDN());
        }
        properties.put("UPnP.presentationURL", dev.getPresentationURL());
        properties.put("UPnP.device.serialNumber", dev.getSerialNumber());
        properties.put("UPnP.device.type", dev.getDeviceType());
        properties.put("UPnP.device.UDN", dev.getUDN());
        properties.put("UPnP.device.UPC", dev.getUPC());
        IconList iconsList = dev.getIconList();
        if (iconsList.size() != 0) {
            for (i = 0; i < iconsList.size(); ++i) {
                UPnPIconImpl icon = new UPnPIconImpl(iconsList.getIcon(i), dev);
                icons.add(icon);
            }
        }
        ServiceList serviceList = dev.getServiceList();
        String[] servicesIDProperty = new String[serviceList.size()];
        HashSet<String> serTypeSet = new HashSet<String>();
        for (int i2 = 0; i2 < serviceList.size(); ++i2) {
            Service service = serviceList.getService(i2);
            UPnPServiceImpl serviceImpl = new UPnPServiceImpl(service);
            services.put(service.getServiceID(), serviceImpl);
            servicesIDProperty[i2] = serviceImpl.getId();
            serTypeSet.add(serviceImpl.getType());
        }
        String[] servicesTypeProperty = new String[serTypeSet.size()];
        Iterator iter = serTypeSet.iterator();
        int i3 = 0;
        while (iter.hasNext()) {
            servicesTypeProperty[i3] = (String)iter.next();
            ++i3;
        }
        properties.put("UPnP.service.id", servicesIDProperty);
        properties.put("UPnP.service.type", servicesTypeProperty);
    }
}

