/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.generalchecks.scrutil.DsRootCauseAnalyzer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@HealthCheckService(name="DS Components Ready Check", tags={"systemalive"})
@Designate(ocd=Config.class, factory=true)
public class DsComponentsCheck
implements HealthCheck {
    private final Logger LOG = LoggerFactory.getLogger(DsComponentsCheck.class);
    public static final String HC_NAME = "DS Components Ready Check";
    public static final String HC_DEFAULT_TAG = "systemalive";
    private List<String> componentsList;
    private Result.Status statusForMissing;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DsRootCauseAnalyzer analyzer;
    volatile ServiceComponentRuntime scr;
    private final AtomicBoolean refreshCache = new AtomicBoolean();
    private final AtomicReference<Result> cache = new AtomicReference();

    @Activate
    public void activate(BundleContext ctx, Config config) throws InterruptedException {
        this.componentsList = Arrays.asList(config.components_list());
        this.statusForMissing = config.statusForMissing();
        this.refreshCache.set(false);
        this.LOG.debug("Activated DS Components HC for componentsList={}", this.componentsList);
    }

    public Result execute() {
        Result result = this.cache.get();
        if (result == null || this.refreshCache.compareAndSet(true, false)) {
            result = this.executeInternal();
            if (result.isOk()) {
                this.cache.set(result);
            } else {
                this.cache.set(null);
            }
        }
        return result;
    }

    protected Result executeInternal() {
        FormattingResultLog log = new FormattingResultLog();
        Collection componentDescriptionDTOs = null;
        try {
            componentDescriptionDTOs = this.scr.getComponentDescriptionDTOs(new Bundle[0]);
        }
        catch (Throwable e) {
            log.temporarilyUnavailable("Exception while getting ds component dtos {}", new Object[]{e.getMessage(), e});
        }
        if (componentDescriptionDTOs != null) {
            LinkedList<ComponentDescriptionDTO> watchedComps = new LinkedList<ComponentDescriptionDTO>();
            LinkedList<String> missingComponents = new LinkedList<String>(this.componentsList);
            for (ComponentDescriptionDTO desc : componentDescriptionDTOs) {
                if (!this.componentsList.contains(desc.name)) continue;
                watchedComps.add(desc);
                missingComponents.remove(desc.name);
            }
            for (String missingComp : missingComponents) {
                log.info("No component with name {} is registered in SCR runtime", new Object[]{missingComp});
            }
            int countEnabled = 0;
            int countDisabled = 0;
            for (ComponentDescriptionDTO dsComp : watchedComps) {
                boolean isActive;
                block14: {
                    boolean componentEnabled = this.scr.isComponentEnabled(dsComp);
                    if (componentEnabled) {
                        try {
                            Collection componentConfigurationDTOs = this.scr.getComponentConfigurationDTOs(dsComp);
                            ArrayList<String> idStateTuples = new ArrayList<String>();
                            boolean foundActiveOrSatisfiedConfig = false;
                            for (ComponentConfigurationDTO configDto : componentConfigurationDTOs) {
                                idStateTuples.add("id " + configDto.id + ":" + DsComponentsCheck.toStateString(configDto.state));
                                if (configDto.state != 8 && configDto.state != 4) continue;
                                foundActiveOrSatisfiedConfig = true;
                            }
                            log.debug(dsComp.name + " (" + String.join((CharSequence)",", idStateTuples) + ")", new Object[0]);
                            if (componentConfigurationDTOs.isEmpty() || foundActiveOrSatisfiedConfig) {
                                ++countEnabled;
                                isActive = true;
                                break block14;
                            }
                            ++countDisabled;
                            isActive = false;
                        }
                        catch (Throwable e) {
                            log.temporarilyUnavailable("Exception while getting ds component dtos {}", new Object[]{e.getMessage(), e});
                            isActive = true;
                        }
                    } else {
                        ++countDisabled;
                        isActive = false;
                    }
                }
                if (isActive) continue;
                this.analyzer.logNotEnabledComponent(log, dsComp, componentDescriptionDTOs);
            }
            if (!missingComponents.isEmpty()) {
                log.add(new ResultLog.Entry(this.statusForMissing, missingComponents.size() + " required components are missing in SCR runtime"));
            }
            if (countDisabled > 0) {
                log.add(new ResultLog.Entry(this.statusForMissing, countDisabled + " required components are not active"));
            }
            log.info("{} required components are active", new Object[]{countEnabled});
        }
        return new Result((ResultLog)log);
    }

    static final String toStateString(int state) {
        int FAILED_ACTIVATION = 16;
        switch (state) {
            case 8: {
                return "active";
            }
            case 4: {
                return "satisfied";
            }
            case 1: {
                return "unsatisfied (configuration)";
            }
            case 2: {
                return "unsatisfied (reference)";
            }
            case 16: {
                return "failed activation";
            }
        }
        return String.valueOf(state);
    }

    @Reference(name="scr", updated="updatedServiceComponentRuntime")
    private void setServiceComponentRuntime(ServiceComponentRuntime c) {
        this.scr = c;
    }

    private void unsetServiceComponentRuntime(ServiceComponentRuntime c) {
        this.scr = null;
    }

    protected void updatedServiceComponentRuntime(ServiceComponentRuntime c) {
        this.refreshCache.compareAndSet(false, true);
        this.LOG.debug("invalidate DsComponentsCheck cache");
    }

    @ObjectClassDefinition(name="Health Check: DS Components Ready Check", description="System ready check that checks a list of DS components and provides root cause analysis in case of errors")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "DS Components Ready Check";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {"systemalive"};

        @AttributeDefinition(name="Required Component Names", description="The components that are required to be enabled")
        public String[] components_list();

        @AttributeDefinition(name="Status for missing component", description="Status in case components are missing enabled components")
        public Result.Status statusForMissing() default Result.Status.TEMPORARILY_UNAVAILABLE;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "{hc.name}: {components.list} / missing -> {statusForMissing}";
    }
}

