/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.mergepoint;

import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.mergepoint.ActionSaxHandler;
import org.apache.torque.generator.configuration.mergepoint.ActionSaxHandlerFactories;
import org.apache.torque.generator.configuration.mergepoint.ActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MergepointSaxHandler {
    private MergepointMapping mergepointMapping;
    private ConfigurationProvider configurationProvider;
    private UnitDescriptor unitDescriptor;
    private ConfigurationHandlers configurationHandlers;
    private ActionSaxHandler delegateHandler;
    private boolean finished = false;

    public MergepointSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) {
        if (configurationProvider == null) {
            throw new NullPointerException("configurationProvider must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        if (configurationHandlers == null) {
            throw new NullPointerException("configurationHandlers must not be null");
        }
        this.configurationProvider = configurationProvider;
        this.unitDescriptor = unitDescriptor;
        this.configurationHandlers = configurationHandlers;
    }

    public MergepointMapping getMergepointMapping() {
        if (!this.finished) {
            throw new IllegalStateException("not finished parsing");
        }
        return this.mergepointMapping;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.delegateHandler != null) {
            this.delegateHandler.startElement(uri, localName, qName, attributes);
        } else if ("mergepoint".equals(qName)) {
            String name = attributes.getValue("name");
            if (name == null) {
                throw new SAXException("The tag mergepoint needs to have the attribute name");
            }
            this.mergepointMapping = new MergepointMapping(name);
        } else if ("action".equals(qName)) {
            String type = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type == null) {
                throw new SAXException("The tag action requires the attribute http://www.w3.org/2001/XMLSchema-instance:type");
            }
            ActionSaxHandlerFactories actionSaxHandlerFactories = this.configurationHandlers.getActionSaxHandlerFactories();
            ActionSaxHandlerFactory handlerFactory = actionSaxHandlerFactories.getActionSaxHandlerFactory(type);
            if (handlerFactory == null) {
                throw new SAXException("No handler found for the action of type " + type);
            }
            this.delegateHandler = handlerFactory.getActionSaxHandler(uri, localName, qName, attributes, this.configurationProvider, this.unitDescriptor);
        } else {
            throw new SAXException("unknown element : " + qName);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if ("action".equals(qName)) {
            this.mergepointMapping.addAction(this.delegateHandler.getAction());
            this.delegateHandler = null;
        } else if ("mergepoint".equals(qName)) {
            this.finished = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

