/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.qname;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Namespace {
    public static final char SEPARATOR = '.';
    public static final Namespace ROOT_NAMESPACE = new Namespace("");
    private String namespace;

    public Namespace(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace must not be null");
        }
        this.namespace = namespace;
    }

    public Namespace(Namespace toCopy) {
        if (toCopy == null) {
            throw new NullPointerException("toCopy must not be null");
        }
        this.namespace = toCopy.namespace;
    }

    public Namespace(List<String> namespaceParts) {
        if (namespaceParts == null) {
            throw new NullPointerException("namespaceParts must not be null");
        }
        StringBuffer assembledNamespace = new StringBuffer();
        Iterator<String> partIt = namespaceParts.iterator();
        while (partIt.hasNext()) {
            String part = partIt.next();
            assembledNamespace.append(part);
            if (!partIt.hasNext()) continue;
            assembledNamespace.append('.');
        }
        this.namespace = assembledNamespace.toString();
    }

    public List<String> getParts() {
        if ("".equals(this.namespace)) {
            return new ArrayList<String>();
        }
        String[] partArray = this.namespace.split("\\.");
        return Arrays.asList(partArray);
    }

    public Namespace getParent() {
        int separatorPos = this.namespace.lastIndexOf(46);
        if (separatorPos == -1) {
            return ROOT_NAMESPACE;
        }
        String parentNamespace = this.namespace.substring(0, separatorPos);
        return new Namespace(parentNamespace);
    }

    public boolean isVisibleTo(Namespace otherNamespace) {
        if (otherNamespace == null) {
            throw new NullPointerException("otherNamespace must not be null");
        }
        if (ROOT_NAMESPACE.equals(otherNamespace)) {
            return true;
        }
        if (ROOT_NAMESPACE.equals(this)) {
            return false;
        }
        if (!this.namespace.startsWith(otherNamespace.namespace)) {
            return false;
        }
        if (this.namespace.equals(otherNamespace.namespace)) {
            return true;
        }
        return this.namespace.charAt(otherNamespace.namespace.length()) == '.';
    }

    public boolean isVisibleFrom(Namespace otherNamespace) {
        if (otherNamespace == null) {
            throw new NullPointerException("otherNamespace is null (this namespace is " + this + ")");
        }
        return otherNamespace.isVisibleTo(this);
    }

    public boolean isRoot() {
        return Namespace.ROOT_NAMESPACE.namespace.equals(this.namespace);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Namespace)) {
            return false;
        }
        Namespace otherNamespace = (Namespace)o;
        return otherNamespace.namespace.equals(this.namespace);
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public String toString() {
        return this.namespace;
    }
}

