/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.outlet;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.outlet.DebuggingOutletWrapper;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.qname.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutletConfiguration {
    private Map<QualifiedName, Outlet> outlets = new HashMap<QualifiedName, Outlet>();
    private Map<String, MergepointMapping> mergepointMappings = new HashMap<String, MergepointMapping>();
    private boolean mergepointMappingsResolved = false;

    public OutletConfiguration(Collection<Outlet> outlets, Collection<MergepointMapping> mergepointMappings, UnitDescriptor unitDescriptor) throws ConfigurationException {
        if (outlets == null) {
            throw new NullPointerException("outlets must not be null");
        }
        if (mergepointMappings == null) {
            throw new NullPointerException("mergepointMappings must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        for (Outlet outlet : outlets) {
            this.addOutlet(outlet, unitDescriptor);
        }
        for (MergepointMapping mergepointMapping : mergepointMappings) {
            this.mergepointMappings.put(mergepointMapping.getName(), mergepointMapping);
        }
    }

    public void resolveMergepointMappings() throws ConfigurationException {
        for (Map.Entry<String, MergepointMapping> entry : this.mergepointMappings.entrySet()) {
            String name = entry.getKey();
            QualifiedName qualifiedMergepointName = new QualifiedName(name);
            if (qualifiedMergepointName.getNamespace().isRoot()) {
                throw new ConfigurationException("The isolated mergepoint mapping with the name " + name + " needs to be qualified with the outlet name");
            }
            QualifiedName outletName = new QualifiedName(qualifiedMergepointName.getNamespace().toString());
            Outlet outlet = this.outlets.get(outletName);
            if (outlet == null) {
                throw new ConfigurationException("No outlet with name " + outletName + "exists (required by the isolated mergepoint mapping" + " with the name " + name + ")");
            }
            MergepointMapping originalMergepointMapping = entry.getValue();
            MergepointMapping resolvedMergepointMapping = new MergepointMapping(qualifiedMergepointName.getName(), originalMergepointMapping.getActions());
            outlet.setMergepointMapping(resolvedMergepointMapping);
        }
        this.mergepointMappingsResolved = true;
        this.mergepointMappings.clear();
    }

    public Map<QualifiedName, Outlet> getOutlets() {
        if (!this.mergepointMappingsResolved) {
            throw new IllegalStateException("Mergepoint mappings must be resoved first");
        }
        return Collections.unmodifiableMap(this.outlets);
    }

    public Outlet getOutlet(QualifiedName name) {
        if (!this.mergepointMappingsResolved) {
            throw new IllegalStateException("Mergepoint mappings must be resoved first");
        }
        return this.outlets.get(name);
    }

    public void addOutlet(Outlet outlet, UnitDescriptor unitDescriptor) throws ConfigurationException {
        if (outlet == null) {
            throw new NullPointerException("outlet must not be null");
        }
        if (unitDescriptor == null) {
            throw new NullPointerException("unitDescriptor must not be null");
        }
        Outlet existingOutlet = this.outlets.get(outlet.getName());
        if (existingOutlet != null) {
            throw new ConfigurationException("Trying to add the outlet " + outlet.getName() + " and class " + outlet.getClass().getName() + " : A outlet with the same name " + " already exists, it has the class " + existingOutlet.getClass().getName());
        }
        if (unitDescriptor.isAddDebuggingInfoToOutput()) {
            outlet = new DebuggingOutletWrapper(outlet);
        }
        this.outlets.put(outlet.getName(), outlet);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("(outlets=[").append(this.outlets).append(")");
        return result.toString();
    }

    public boolean outletExists(QualifiedName qualifiedName) {
        return this.outlets.containsKey(qualifiedName);
    }
}

