/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RoutinesDefinersRightsTest
extends BaseJDBCTestCase {
    private static final String pwSuffix = "pwSuffix";
    private static final String NOEXECUTEPERMISSION = "42504";
    private static final String NOCOLUMNPERMISSION = "42502";
    private static final String MULTIPLE_ELEMENTS = "42613";
    private static final int BOSS = 0;
    private static final int MIDDLEMANAGER = 1;
    private static final int FOOTSOLDIER = 2;
    private static final String[] users = new String[]{"test_dbo", "PHB", "Dilbert"};
    private static final double[] wages = new double[]{1000.0, 500.0, 100.0};
    private static final int[] categories = new int[]{0, 1, 2};

    public RoutinesDefinersRightsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("RoutinesDefinersRightsTest");
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(RoutinesDefinersRightsTest.makeSuite());
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(RoutinesDefinersRightsTest.makeSuite()));
        }
        return baseTestSuite;
    }

    private static Test makeSuite() {
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)new BaseTestSuite(RoutinesDefinersRightsTest.class)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create role middleManager");
                statement.execute("create table s1.wages(employeeId int,                   category int,                   salary double,                   name VARCHAR(20))");
                PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into s1.wages values (?,?,?,?)");
                for (int i = 0; i <= 2; ++i) {
                    preparedStatement.setInt(1, 1000 + i);
                    preparedStatement.setInt(2, i);
                    preparedStatement.setDouble(3, wages[i]);
                    preparedStatement.setString(4, users[i]);
                    preparedStatement.execute();
                }
                preparedStatement.close();
                statement.execute("create function s1.lookupWageFootSoldier(int) returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupWageFootSoldier' EXTERNAL SECURITY DEFINER reads sql data called on null input");
                statement.execute("create procedure s1.updateWage() language java parameter style java modifies sql data external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.updateWage' EXTERNAL SECURITY DEFINER ");
                statement.execute("grant execute on function s1.lookupWageFootSoldier    to phb");
                statement.execute("grant execute on procedure s1.updateWage    to phb");
                statement.execute("create function s1.lookupWageFootSoldierI(int) returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupWageFootSoldier' EXTERNAL SECURITY INVOKER reads sql data called on null input");
                statement.execute("grant execute on function     s1.lookupWageFootSoldierI to phb");
                statement.execute("create procedure s1.spTestBuiltins() language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.spTestBuiltins' EXTERNAL SECURITY DEFINER reads sql data");
                statement.execute("grant execute on procedure s1.spTestBuiltins    to phb");
                statement.execute("create function s1.selectFootSoldiers() returns table (    employeeId int,    category int,    salary double,    name varchar(20))language java parameter style     derby_jdbc_result_set external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.selectFootSoldiers' EXTERNAL SECURITY DEFINER reads sql data");
                statement.execute("grant execute on function s1.selectFootSoldiers     to middleManager");
                statement.execute("grant middleManager to phb");
                statement.execute("create function s1.selectFootSoldiersI() returns table (    employeeId int,    category int,    salary double,    name varchar(20))language java parameter style     derby_jdbc_result_set external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.selectFootSoldiers' EXTERNAL SECURITY INVOKER reads sql data");
                statement.execute("grant execute on function s1.selectFootSoldiersI     to middleManager");
                statement.execute("create schema phb authorization phb");
                statement.execute("create function phb.lookupDilbertWage() returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupDilbertWage' EXTERNAL SECURITY DEFINER reads sql data called on null input");
                statement.execute("grant execute on function phb.lookupDilbertWage     to dilbert");
                BaseJDBCTestCase.assertStatementError(new String[]{RoutinesDefinersRightsTest.MULTIPLE_ELEMENTS}, statement, "create function phb.lookupDilbertWage() returns double language java parameter style java external name 'org.apache.derbyTesting.functionTests.tests.lang.RoutinesDefinersRightsTest.lookupDilbertWage' EXTERNAL SECURITY DEFINER EXTERNAL SECURITY INVOKER reads sql data called on null input");
            }
        };
        return TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, users, pwSuffix));
    }

    public void testDefinersRights() throws SQLException {
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        TestConfiguration.getCurrent().shutdownDatabase();
        connection = this.openUserConnection("Dilbert");
        statement = connection.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOEXECUTEPERMISSION}, statement, "values s1.lookupWageFootSoldier(1002)");
        statement.close();
        connection.close();
        connection = this.openUserConnection("PHB");
        statement = connection.createStatement();
        resultSet = statement.executeQuery("values s1.lookupWageFootSoldier(1002)");
        JDBC.assertSingleValueResultSet(resultSet, "100.0");
        statement.executeUpdate("call s1.updateWage()");
        statement.close();
        connection.close();
        Connection connection2 = this.getConnection();
        Statement statement2 = connection2.createStatement();
        resultSet = statement2.executeQuery("values s1.lookupWageFootSoldier(1002)");
        JDBC.assertSingleValueResultSet(resultSet, "100.0");
        resultSet = statement2.executeQuery("values s1.lookupWageFootSoldier(1001)");
        JDBC.assertSingleValueResultSet(resultSet, "-1.0");
        statement2.close();
        connection2.close();
        connection = this.openUserConnection("PHB");
        statement = connection.createStatement();
        statement.executeUpdate("set role middlemanager");
        resultSet = statement.executeQuery("select * from table (s1.selectFootSoldiers()) as t");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1002", "2", "100.0", "Dilbert"}});
        resultSet = statement.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"PHB", "PHB", "\"MIDDLEMANAGER\""}});
        statement.close();
        connection.close();
        connection = this.openUserConnection("Dilbert");
        statement = connection.createStatement();
        resultSet = statement.executeQuery("values phb.lookupDilbertWage()");
        JDBC.assertSingleValueResultSet(resultSet, "100.0");
        resultSet = statement.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"DILBERT", "DILBERT", null}});
        statement.close();
        connection.close();
    }

    public void testBuiltins() throws SQLException {
        Connection connection = this.openUserConnection("PHB");
        Statement statement = connection.createStatement();
        statement.executeUpdate("set role middlemanager");
        statement.executeUpdate("call s1.spTestBuiltins()");
        statement.close();
        connection.close();
    }

    public void testInvokersRights() throws SQLException {
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        connection = this.openUserConnection("Dilbert");
        statement = connection.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOEXECUTEPERMISSION}, statement, "values s1.lookupWageFootSoldierI(1002)");
        statement.close();
        connection.close();
        connection = this.openUserConnection("PHB");
        statement = connection.createStatement();
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOCOLUMNPERMISSION}, statement, "values s1.lookupWageFootSoldierI(1002)");
        statement.close();
        connection.close();
        Connection connection2 = this.getConnection();
        Statement statement2 = connection2.createStatement();
        resultSet = statement2.executeQuery("values s1.lookupWageFootSoldierI(1002)");
        JDBC.assertSingleValueResultSet(resultSet, "100.0");
        statement2.close();
        connection2.close();
        connection = this.openUserConnection("PHB");
        statement = connection.createStatement();
        statement.executeUpdate("set role middlemanager");
        RoutinesDefinersRightsTest.assertStatementError(new String[]{NOCOLUMNPERMISSION}, statement, "select * from table (s1.selectFootSoldiersI()) as t");
        resultSet = statement.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"PHB", "PHB", "\"MIDDLEMANAGER\""}});
        statement.close();
        connection.close();
    }

    public static double lookupWageFootSoldier(int n) throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select salary from s1.wages where employeeId=" + n + " and category = 2");
        if (resultSet.next()) {
            double d = resultSet.getDouble(1);
            statement.close();
            resultSet.close();
            connection.close();
            return d;
        }
        statement.close();
        resultSet.close();
        connection.close();
        return -1.0;
    }

    public static void updateWage() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from s1.wages");
        RoutinesDefinersRightsTest.assertTrue((boolean)resultSet.isBeforeFirst());
        resultSet.moveToInsertRow();
        resultSet.updateInt("EMPLOYEEID", 666);
        resultSet.updateInt("CATEGORY", 667);
        resultSet.updateDouble("SALARY", 666.0);
        resultSet.updateString("NAME", "N.N.");
        resultSet.insertRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from s1.wages where name = 'N.N.'");
        resultSet.next();
        resultSet.updateDouble("SALARY", 666.1);
        resultSet.updateRow();
        resultSet.close();
        resultSet = statement.executeQuery("select * from s1.wages where name = 'N.N.'");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        statement.close();
        connection.close();
    }

    public static ResultSet selectFootSoldiers() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from s1.wages where category = 2");
        return resultSet;
    }

    public static double lookupDilbertWage() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        connection.commit();
        statement.executeUpdate("set role middlemanager");
        ResultSet resultSet = statement.executeQuery("values (current_user, session_user, current_role)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"PHB", "DILBERT", "\"MIDDLEMANAGER\""}});
        resultSet = statement.executeQuery("select salary from table (s1.selectFootSoldiers()) as t     where name='Dilbert'");
        resultSet.next();
        double d = resultSet.getDouble(1);
        resultSet.close();
        statement.close();
        connection.close();
        return d;
    }

    public static void spTestBuiltins() throws SQLException {
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("values (user, current_user, current schema,         session_user, current_role)");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"TEST_DBO", "TEST_DBO", "TEST_DBO", "PHB", null}});
        statement.close();
        connection.close();
    }
}

