<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements. See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership. The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

-->

# Contribute

Contributions to this project will be gratefully received.

Feel free to subscribe to the
[dev@commons](mail-lists.html)
mailing list to follow the ongoing development of Commons RDF, ask questions
about its usage, or help shape Commons RDF by contributing your ideas, code and
use cases. Please use the Subject tag `[RDF]` in your posts.

You can contribute to Apache Commons RDF in many ways:

 * Participate in the design discussions on [dev@commons](mail-lists.html)
 * Implement the Commons RDF API in your own [implementation](implementations.html)
 * Raise an [issue](https://issues.apache.org/jira/browse/COMMONSRDF)
 * Raise a [pull request](https://github.com/apache/commons-rdf/pulls) to:
    + Contribute new [tests](https://github.com/apache/commons-rdf/tree/master/api/src/test/java/org/apache/commons/rdf/api)   
    + Suggest changes to the [API](https://github.com/apache/commons-rdf/tree/master/api/)
    + Improve the [Javadocs](apidocs/)
    + Fix bugs in the [simple](https://github.com/apache/commons-rdf/tree/master/simple/src/main/java/org/apache/commons/rdf/simple) implementation
    + .. and more
 * Improve the [website](https://commons.apache.org/proper/commons-rdf/) by:
    + Raising a pull request for changes to [src/site](https://github.com/apache/commons-rdf/tree/master/src/site)
    + Contribute example use cases

All ASF committers have write access to Apache Commons repositories
and are welcome to contribute directly. (No need to ask!) Please make sure
you have subscribed to the [dev@commons](mail-lists.html) list first for
any feedback.  We do ask that you 
raise a corresponding [issue](https://issues.apache.org/jira/browse/COMMONSRDF)
referenced in your commits (e.g. 
`COMMONSRDF-999: Avoid NullPointerException in GraphImpl.iterate()`). 
Larger changes or any changes to the [api](api/) should be raised as a 
[pull request](https://github.com/apache/commons-rdf/pulls) for code
review and discussion.
 
All contributions are assumed to be under the
[Apache License, version 2.0](http://www.apache.org/licenses/LICENSE-2.0),
however we may ask you to also sign a 
[software grant](https://www.apache.org/licenses/software-grant.txt) for any 
larger contributions.
 
