/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.jexl342.OptionalArithmetic;
import org.apache.commons.jexl3.jexl342.ReferenceUberspect;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionalTest {
    OptionalTest() {
    }

    @Test
    void test342() {
        JexlBuilder builder = new JexlBuilder();
        JexlUberspect uber = builder.create().getUberspect();
        JexlEngine jexl = builder.uberspect((JexlUberspect)new ReferenceUberspect(uber)).safe(false).create();
        JexlInfo info = new JexlInfo("test352", 1, 1);
        Thing thing = new Thing();
        JexlScript script1 = jexl.createScript(info.at(53, 1), "thing.name.length()", new String[]{"thing"});
        Object result = script1.execute(null, new Object[]{thing});
        Assertions.assertNull((Object)result);
        thing.name = "foo";
        result = script1.execute(null, new Object[]{thing});
        Assertions.assertEquals((Object)3, (Object)result);
        JexlScript script2 = jexl.createScript(info.at(62, 1), "thing.name.size()", new String[]{"thing"});
        JexlException.Method xmethod = (JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script2.execute(null, new Object[]{thing}));
        Assertions.assertEquals((Object)"size", (Object)xmethod.getDetail());
        Assertions.assertEquals((Object)"test352@62:11 unsolvable function/method 'size'", (Object)xmethod.getMessage());
        JexlScript script3 = jexl.createScript(info.at(71, 1), "thing.name?.size()", new String[]{"thing"});
        result = script3.execute(null, new Object[]{thing});
        thing.name = null;
        script1 = jexl.createScript(info, "thing.names.size()", new String[]{"thing"});
        result = script1.execute(null, new Object[]{thing});
        Assertions.assertNull((Object)result);
        thing.name = "froboz";
        script1 = jexl.createScript(info, "thing.names", new String[]{"thing"});
        result = script1.execute(null, new Object[]{thing});
        Assertions.assertNotNull((Object)result);
        script1 = jexl.createScript(info, "thing.names.size()", new String[]{"thing"});
        result = script1.execute(null, new Object[]{thing});
        Assertions.assertEquals((Object)1, (Object)result);
    }

    @Test
    void testOptionalArgs() {
        JexlBuilder builder = new JexlBuilder();
        OptionalArithmetic jexla = new OptionalArithmetic(true);
        JexlUberspect uber = builder.create().getUberspect();
        JexlEngine jexl = builder.uberspect((JexlUberspect)new ReferenceUberspect(uber)).arithmetic((JexlArithmetic)jexla).safe(false).create();
        JexlInfo info = new JexlInfo("testStream", 1, 1);
        StreamContext context = new StreamContext();
        String src = "x + x";
        JexlScript script = jexl.createScript("x + x", new String[]{"x"});
        Optional<Integer> x = Optional.of(21);
        Object result = script.execute((JexlContext)context, new Object[]{x});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    void testStream0() {
        String src = "$0.map(x -> x * x).reduce((a, x) -> a + x)";
        JexlBuilder builder = new JexlBuilder();
        JexlUberspect uber = builder.create().getUberspect();
        OptionalArithmetic jexla = new OptionalArithmetic(true);
        JexlEngine jexl = builder.uberspect((JexlUberspect)new ReferenceUberspect(uber)).arithmetic((JexlArithmetic)jexla).safe(false).create();
        JexlInfo info = new JexlInfo("testStream", 1, 1);
        StreamContext context = new StreamContext();
        JexlScript script = jexl.createScript("$0.map(x -> x * x).reduce((a, x) -> a + x)", new String[]{"$0"});
        Object result = script.execute((JexlContext)context, new Object[]{Arrays.asList(1, 2, 3)});
        Assertions.assertEquals((Object)14, (Object)result);
    }

    @Test
    void testStream1() {
        String src = "$0.map(x -> x * x).reduce((a, x) -> a + x)";
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        JexlInfo info = new JexlInfo("testStream", 1, 1);
        StreamContext context = new StreamContext();
        JexlScript script = jexl.createScript("$0.map(x -> x * x).reduce((a, x) -> a + x)", new String[]{"$0"});
        Object result = script.execute((JexlContext)context, new Object[]{Arrays.asList(1, 2.0, "3")});
        Assertions.assertEquals((double)14.0, (double)((Double)result), (double)1.0E-5);
    }

    public static class Thing {
        String name;

        public Optional<String> findName() {
            return Optional.ofNullable(this.name);
        }

        public Optional<List<String>> findNames() {
            if (this.name == null) {
                return Optional.empty();
            }
            return Optional.of(Collections.singletonList(this.name));
        }
    }

    public static class StreamContext
    extends MapContext {
        public Stream map(Collection<Object> c, JexlScript s) {
            JexlContext.ThreadLocal context = JexlEngine.getThreadContext();
            return c.stream().map(arg_0 -> StreamContext.lambda$map$0(s, (JexlContext)context, arg_0));
        }

        public Object reduce(Stream<Object> stream, JexlScript script) {
            Optional<Object> reduced = stream.reduce((identity, element) -> {
                JexlContext.ThreadLocal context = JexlEngine.getThreadContext();
                return script.execute((JexlContext)context, new Object[]{identity, element});
            });
            return reduced instanceof Optional ? reduced.get() : reduced;
        }

        private static /* synthetic */ Object lambda$map$0(JexlScript s, JexlContext context, Object a) {
            return s.execute(context, new Object[]{a});
        }
    }
}

