/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestProvidedURLLocationStrategy {
    private ProvidedURLLocationStrategy strategy;

    @BeforeEach
    public void setUp() throws Exception {
        this.strategy = new ProvidedURLLocationStrategy();
    }

    @Test
    void testLocateFail() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath("somePath").fileName("someFile.xml").create();
        Assertions.assertNull((Object)this.strategy.locate(fs, locator));
    }

    @Test
    void testLocateSuccess() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        URL url = ConfigurationAssert.getTestURL("test.xml");
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(url).create();
        Assertions.assertSame((Object)url, (Object)this.strategy.locate(fs, locator));
    }
}

