/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.trevni.ColumnFileReader;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.MetaData;
import org.apache.trevni.TrevniRuntimeException;
import org.apache.trevni.ValueType;

public class ColumnMetaData
extends MetaData<ColumnMetaData> {
    static final String NAME_KEY = "trevni.name";
    static final String TYPE_KEY = "trevni.type";
    static final String VALUES_KEY = "trevni.values";
    static final String PARENT_KEY = "trevni.parent";
    static final String ARRAY_KEY = "trevni.array";
    private String name;
    private ValueType type;
    private boolean values;
    private ColumnMetaData parent;
    private boolean isArray;
    private transient List<ColumnMetaData> children = new ArrayList<ColumnMetaData>(0);
    private transient int number = -1;

    private ColumnMetaData() {
    }

    public ColumnMetaData(String name, ValueType type) {
        this.name = name;
        this.setReserved(NAME_KEY, name);
        this.type = type;
        this.setReserved(TYPE_KEY, type.getName());
    }

    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return this.type;
    }

    public ColumnMetaData getParent() {
        return this.parent;
    }

    public List<ColumnMetaData> getChildren() {
        return this.children;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getNumber() {
        return this.number;
    }

    void setNumber(int number) {
        this.number = number;
    }

    public ColumnMetaData hasIndexValues(boolean values) {
        if (this.isArray) {
            throw new TrevniRuntimeException("Array column cannot have index: " + String.valueOf(this));
        }
        this.values = values;
        return (ColumnMetaData)this.setReservedBoolean(VALUES_KEY, values);
    }

    public ColumnMetaData setParent(ColumnMetaData parent) {
        if (!parent.isArray()) {
            throw new TrevniRuntimeException("Parent is not an array: " + String.valueOf(parent));
        }
        if (this.values) {
            throw new TrevniRuntimeException("Array column cannot have index: " + String.valueOf(this));
        }
        this.parent = parent;
        parent.children.add(this);
        return (ColumnMetaData)this.setReserved(PARENT_KEY, parent.getName());
    }

    public ColumnMetaData isArray(boolean isArray) {
        if (this.values) {
            throw new TrevniRuntimeException("Array column cannot have index: " + String.valueOf(this));
        }
        this.isArray = isArray;
        return (ColumnMetaData)this.setReservedBoolean(ARRAY_KEY, isArray);
    }

    public boolean hasIndexValues() {
        return this.getBoolean(VALUES_KEY);
    }

    static ColumnMetaData read(InputBuffer in, ColumnFileReader file) throws IOException {
        ColumnMetaData result = new ColumnMetaData();
        MetaData.read(in, result);
        result.name = result.getString(NAME_KEY);
        result.type = ValueType.forName(result.getString(TYPE_KEY));
        result.values = result.getBoolean(VALUES_KEY);
        result.isArray = result.getBoolean(ARRAY_KEY);
        String parentName = result.getString(PARENT_KEY);
        if (parentName != null) {
            result.setParent(file.getColumnMetaData(parentName));
        }
        return result;
    }
}

