/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.query.spi.Limit;

public abstract class AbstractLimitHandler
implements LimitHandler {
    public static LimitHandler NO_LIMIT = new AbstractLimitHandler(){};
    private static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*select\\b", 2);
    private static final Pattern SELECT_DISTINCT_PATTERN = Pattern.compile("^\\s*select(\\s+(distinct|all))?\\b", 2);
    private static final Pattern END_PATTERN = Pattern.compile("\\s*(;|$)", 2);
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("\\s+for\\s+update\\b|\\s*(;|$)", 2);

    @Override
    public boolean supportsLimit() {
        return false;
    }

    @Override
    public boolean supportsOffset() {
        return false;
    }

    @Override
    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return !this.supportsLimitOffset();
    }

    public boolean forceLimitUsage() {
        return false;
    }

    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult;
    }

    @Override
    public String processSql(String sql, Limit limit) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        return this.bindLimitParametersFirst() ? this.bindLimitParameters(limit, statement, index) : 0;
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(Limit limit, PreparedStatement statement, int index) throws SQLException {
        return !this.bindLimitParametersFirst() ? this.bindLimitParameters(limit, statement, index) : 0;
    }

    @Override
    public void setMaxRows(Limit limit, PreparedStatement statement) throws SQLException {
    }

    protected final int bindLimitParameters(Limit limit, PreparedStatement statement, int index) throws SQLException {
        boolean bindOffset;
        if (!this.supportsVariableLimit()) {
            return 0;
        }
        boolean hasMaxRows = AbstractLimitHandler.hasMaxRows(limit);
        boolean hasFirstRow = AbstractLimitHandler.hasFirstRow(limit);
        boolean bindLimit = hasMaxRows && this.supportsLimit() || this.forceLimitUsage();
        boolean bl = bindOffset = hasFirstRow && this.supportsOffset() || hasFirstRow && hasMaxRows && this.supportsLimitOffset();
        if (!bindLimit && !bindOffset) {
            return 0;
        }
        boolean reverse = this.bindLimitParametersInReverseOrder();
        if (bindOffset) {
            statement.setInt(index + (reverse && bindLimit ? 1 : 0), this.getFirstRow(limit));
        }
        if (bindLimit) {
            statement.setInt(index + (reverse || !bindOffset ? 0 : 1), this.getMaxOrLimit(limit));
        }
        return bindOffset && bindLimit ? 2 : 1;
    }

    public static boolean hasMaxRows(Limit limit) {
        return limit != null && limit.getMaxRows() != null && limit.getMaxRows() > 0;
    }

    public static boolean hasFirstRow(Limit limit) {
        return limit != null && limit.getFirstRow() != null && limit.getFirstRow() > 0;
    }

    protected final int getMaxOrLimit(Limit limit) {
        if (limit == null || limit.getMaxRows() == null) {
            return Integer.MAX_VALUE;
        }
        int firstRow = this.getFirstRow(limit);
        int maxRows = limit.getMaxRows();
        int maxOrLimit = this.useMaxForLimit() ? maxRows + firstRow : maxRows;
        return maxOrLimit < 0 ? Integer.MAX_VALUE : maxOrLimit;
    }

    protected final int getFirstRow(Limit limit) {
        if (limit == null || limit.getFirstRow() == null) {
            return 0;
        }
        return this.convertToFirstRowValue(limit.getFirstRow());
    }

    protected static String insertAfterSelect(String limitOffsetClause, String sqlStatement) {
        Matcher selectMatcher = SELECT_PATTERN.matcher(sqlStatement);
        if (selectMatcher.find()) {
            return new StringBuilder(sqlStatement).insert(selectMatcher.end(), limitOffsetClause).toString();
        }
        return sqlStatement;
    }

    protected static String insertAfterDistinct(String limitOffsetClause, String sqlStatement) {
        Matcher selectDistinctMatcher = SELECT_DISTINCT_PATTERN.matcher(sqlStatement);
        if (selectDistinctMatcher.find()) {
            return new StringBuilder(sqlStatement).insert(selectDistinctMatcher.end(), limitOffsetClause).toString();
        }
        return sqlStatement;
    }

    protected String insertAtEnd(String limitOffsetClause, String sqlStatement) {
        Matcher endMatcher = END_PATTERN.matcher(sqlStatement);
        if (endMatcher.find()) {
            return new StringBuilder(sqlStatement).insert(endMatcher.start(), limitOffsetClause).toString();
        }
        return sqlStatement;
    }

    protected Pattern getForUpdatePattern() {
        return FOR_UPDATE_PATTERN;
    }

    protected String insertBeforeForUpdate(String limitOffsetClause, String sqlStatement) {
        Matcher forUpdateMatcher = this.getForUpdatePattern().matcher(sqlStatement);
        if (forUpdateMatcher.find()) {
            return new StringBuilder(sqlStatement).insert(forUpdateMatcher.start(), limitOffsetClause).toString();
        }
        return sqlStatement;
    }
}

