/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.events;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Node;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.apiimpl.VizEvent;
import org.gephi.visualization.apiimpl.VizEventListener;
import org.gephi.visualization.apiimpl.VizEventManager;
import org.gephi.visualization.model.node.NodeModel;
import org.gephi.visualization.opengl.AbstractEngine;

public class StandardVizEventManager
implements VizEventManager {
    private static final int PRESSING_FREQUENCY = 5;
    private static final int DRAGGING_FREQUENCY = 5;
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10));
    private AbstractEngine engine;
    private GraphIO graphIO;
    private VizEventTypeHandler[] handlers;
    private int pressingTick = 0;
    private int draggingTick = 0;

    @Override
    public void initArchitecture() {
        this.engine = VizController.getInstance().getEngine();
        this.graphIO = VizController.getInstance().getGraphIO();
        ArrayList<VizEventTypeHandler> handlersList = new ArrayList<VizEventTypeHandler>();
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_LEFT_CLICK, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_LEFT_PRESS, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_MIDDLE_CLICK, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_MIDDLE_PRESS, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_RIGHT_CLICK, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_RIGHT_PRESS, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_MOVE, true));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.START_DRAG, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.DRAG, true));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.STOP_DRAG, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.NODE_LEFT_CLICK, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_LEFT_PRESSING, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.MOUSE_RELEASED, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.NODE_LEFT_PRESS, false));
        handlersList.add(new VizEventTypeHandler(VizEvent.Type.NODE_LEFT_PRESSING, false));
        Collections.sort(handlersList, new Comparator(){

            public int compare(Object o1, Object o2) {
                VizEvent.Type t1 = ((VizEventTypeHandler)o1).type;
                VizEvent.Type t2 = ((VizEventTypeHandler)o2).type;
                return t1.compareTo(t2);
            }
        });
        this.handlers = handlersList.toArray(new VizEventTypeHandler[0]);
    }

    @Override
    public void mouseLeftClick() {
        List<NodeModel> modelArray;
        VizEventTypeHandler mouseLeftHandler;
        List<NodeModel> modelArray2;
        VizEventTypeHandler nodeLeftHandler = this.handlers[VizEvent.Type.NODE_LEFT_CLICK.ordinal()];
        if (nodeLeftHandler.hasListeners() && VizController.getInstance().getVizConfig().isSelectionEnable() && (modelArray2 = this.engine.getSelectedNodes()).size() > 0) {
            Node[] nodeArray = new Node[modelArray2.size()];
            for (int i = 0; i < modelArray2.size(); ++i) {
                nodeArray[i] = modelArray2.get(i).getNode();
            }
            nodeLeftHandler.dispatch(nodeArray);
        }
        if ((mouseLeftHandler = this.handlers[VizEvent.Type.MOUSE_LEFT_CLICK.ordinal()]).hasListeners() && ((modelArray = this.engine.getSelectedNodes()).isEmpty() || !VizController.getInstance().getVizConfig().isSelectionEnable())) {
            float[] mousePositionViewport = this.graphIO.getMousePosition();
            float[] mousePosition3d = this.graphIO.getMousePosition3d();
            float[] mousePos = new float[]{mousePositionViewport[0], mousePositionViewport[1], mousePosition3d[0], mousePosition3d[1]};
            this.handlers[VizEvent.Type.MOUSE_LEFT_CLICK.ordinal()].dispatch(mousePos);
        }
    }

    @Override
    public void mouseLeftPress() {
        List<NodeModel> modelArray;
        this.handlers[VizEvent.Type.MOUSE_LEFT_PRESS.ordinal()].dispatch();
        this.pressingTick = 5;
        VizEventTypeHandler pressHandler = this.handlers[VizEvent.Type.NODE_LEFT_PRESS.ordinal()];
        if (pressHandler.hasListeners() && !(modelArray = this.engine.getSelectedNodes()).isEmpty()) {
            Node[] nodeArray = new Node[modelArray.size()];
            for (int i = 0; i < modelArray.size(); ++i) {
                nodeArray[i] = modelArray.get(i).getNode();
            }
            pressHandler.dispatch(nodeArray);
        }
    }

    @Override
    public void mouseMiddleClick() {
        this.handlers[VizEvent.Type.MOUSE_MIDDLE_CLICK.ordinal()].dispatch();
    }

    @Override
    public void mouseMiddlePress() {
        this.handlers[VizEvent.Type.MOUSE_LEFT_PRESS.ordinal()].dispatch();
    }

    @Override
    public void mouseMove() {
        this.handlers[VizEvent.Type.MOUSE_MOVE.ordinal()].dispatch();
    }

    @Override
    public void mouseRightClick() {
        this.handlers[VizEvent.Type.MOUSE_RIGHT_CLICK.ordinal()].dispatch();
    }

    @Override
    public void mouseRightPress() {
        this.handlers[VizEvent.Type.MOUSE_RIGHT_PRESS.ordinal()].dispatch();
    }

    @Override
    public void mouseLeftPressing() {
        if (this.pressingTick++ >= 5) {
            List<NodeModel> modelArray;
            this.pressingTick = 0;
            VizEventTypeHandler nodeHandler = this.handlers[VizEvent.Type.NODE_LEFT_PRESSING.ordinal()];
            if (nodeHandler.hasListeners() && !(modelArray = this.engine.getSelectedNodes()).isEmpty()) {
                Node[] nodeArray = new Node[modelArray.size()];
                for (int i = 0; i < modelArray.size(); ++i) {
                    nodeArray[i] = modelArray.get(i).getNode();
                }
                nodeHandler.dispatch(nodeArray);
            }
        }
    }

    @Override
    public void startDrag() {
        this.handlers[VizEvent.Type.START_DRAG.ordinal()].dispatch();
    }

    @Override
    public void stopDrag() {
        this.handlers[VizEvent.Type.STOP_DRAG.ordinal()].dispatch();
    }

    @Override
    public void drag() {
        if (this.draggingTick++ >= 5) {
            this.draggingTick = 0;
            VizEventTypeHandler handler = this.handlers[VizEvent.Type.DRAG.ordinal()];
            if (handler.hasListeners()) {
                float[] mouseDrag = Arrays.copyOf(this.graphIO.getMouseDrag(), 4);
                mouseDrag[2] = this.graphIO.getMouseDrag3d()[0];
                mouseDrag[3] = this.graphIO.getMouseDrag3d()[1];
                handler.dispatch(mouseDrag);
            }
        }
    }

    @Override
    public void mouseReleased() {
        this.handlers[VizEvent.Type.MOUSE_RELEASED.ordinal()].dispatch();
    }

    @Override
    public boolean hasListeners(VizEvent.Type type) {
        return this.handlers[type.ordinal()].hasListeners();
    }

    @Override
    public void addListener(VizEventListener listener) {
        this.handlers[listener.getType().ordinal()].addListener(listener);
    }

    @Override
    public void removeListener(VizEventListener listener) {
        this.handlers[listener.getType().ordinal()].removeListener(listener);
    }

    @Override
    public void addListener(VizEventListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.handlers[listeners[i].getType().ordinal()].addListener(listeners[i]);
        }
    }

    @Override
    public void removeListener(VizEventListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.handlers[listeners[i].getType().ordinal()].removeListener(listeners[i]);
        }
    }

    private class VizEventTypeHandler {
        protected final VizEvent.Type type;
        private final boolean limitRunning;
        protected List<WeakReference<VizEventListener>> listeners;
        protected Runnable runnable;
        protected boolean running;

        public VizEventTypeHandler(VizEvent.Type type, boolean limitRunning) {
            this.limitRunning = limitRunning;
            this.type = type;
            this.listeners = new ArrayList<WeakReference<VizEventListener>>();
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    VizEventTypeHandler.this.fireVizEvent(null);
                    VizEventTypeHandler.this.running = false;
                }
            };
        }

        protected synchronized void addListener(VizEventListener listener) {
            WeakReference<VizEventListener> weakListener = new WeakReference<VizEventListener>(listener);
            this.listeners.add(weakListener);
        }

        protected synchronized void removeListener(VizEventListener listener) {
            Iterator<WeakReference<VizEventListener>> itr = this.listeners.iterator();
            while (itr.hasNext()) {
                WeakReference<VizEventListener> li = itr.next();
                if (li.get() != listener) continue;
                itr.remove();
            }
        }

        protected void dispatch() {
            if (this.limitRunning && this.running) {
                return;
            }
            if (this.listeners.size() > 0) {
                this.running = true;
                StandardVizEventManager.this.pool.submit(this.runnable);
            }
        }

        protected void dispatch(final Object data) {
            if (this.limitRunning && this.running) {
                return;
            }
            if (this.listeners.size() > 0) {
                this.running = true;
                StandardVizEventManager.this.pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VizEventTypeHandler.this.fireVizEvent(data);
                            VizEventTypeHandler.this.running = false;
                        }
                        catch (Exception e) {
                            Logger.getLogger("").log(Level.SEVERE, null, e);
                        }
                    }
                });
            }
        }

        protected boolean isRunning() {
            return this.running;
        }

        private synchronized void fireVizEvent(Object data) {
            VizEvent event = new VizEvent(this, this.type, data);
            for (int i = 0; i < this.listeners.size(); ++i) {
                WeakReference<VizEventListener> weakListener = this.listeners.get(i);
                VizEventListener v = (VizEventListener)weakListener.get();
                v.handleEvent(event);
            }
        }

        public boolean hasListeners() {
            return this.listeners.size() > 0;
        }

        protected int getIndex() {
            return this.type.ordinal();
        }
    }
}

