/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import javax.xml.stream.XMLStreamReader;
import org.gephi.project.api.GephiFormatException;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectsImpl;
import org.gephi.project.impl.WorkspaceImpl;
import org.gephi.project.impl.WorkspaceInformationImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class GephiReader {
    static final String VERSION = "0.9";

    public static ProjectImpl readProject(XMLStreamReader reader, ProjectsImpl projects) throws Exception {
        ProjectImpl project = null;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if ("projectFile".equalsIgnoreCase(name) || "gephiFile".equalsIgnoreCase(name)) {
                    String version = reader.getAttributeValue(null, "version");
                    if (version != null && !version.isEmpty() && !(Double.parseDouble(version) < Double.parseDouble(VERSION))) continue;
                    throw new GephiFormatException("Gephi project file version must be at least of version 0.9");
                }
                if ("project".equalsIgnoreCase(name)) {
                    String projectName = reader.getAttributeValue(null, "name");
                    String projectId = reader.getAttributeValue(null, "id");
                    if (projectId == null) {
                        project = new ProjectImpl(projectName);
                    } else {
                        if (projects != null) {
                            project = projects.getProjectByIdentifier(projectId);
                        }
                        if (project == null) {
                            project = new ProjectImpl(projectId, projectName);
                        }
                    }
                    project.getLookup().lookup(WorkspaceProviderImpl.class);
                    if (reader.getAttributeValue(null, "ids") == null) continue;
                    int workspaceIds = Integer.parseInt(reader.getAttributeValue(null, "ids"));
                    project.setWorkspaceIds(workspaceIds);
                    continue;
                }
                if (!"metadata".equalsIgnoreCase(name)) continue;
                GephiReader.readProjectMetadata(reader, project);
                continue;
            }
            if (!eventType.equals(2) || !"project".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        return project;
    }

    public static WorkspaceImpl readWorkspace(XMLStreamReader reader, ProjectImpl project) throws Exception {
        WorkspaceImpl workspace = null;
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if ("workspace".equalsIgnoreCase(name)) {
                    Integer workspaceId = reader.getAttributeValue(null, "id") == null || project.getWorkspace(Integer.parseInt(reader.getAttributeValue(null, "id"))) != null ? Integer.valueOf(project.nextWorkspaceId()) : Integer.valueOf(Integer.parseInt(reader.getAttributeValue(null, "id")));
                    workspace = project.newWorkspace(workspaceId);
                    WorkspaceInformationImpl info = (WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class);
                    info.setName(reader.getAttributeValue(null, "name"));
                    String workspaceStatus = reader.getAttributeValue(null, "status");
                    if (workspaceStatus.equals("open")) {
                        info.open();
                        continue;
                    }
                    if (workspaceStatus.equals("closed")) {
                        info.close();
                        continue;
                    }
                    info.invalid();
                    continue;
                }
                if (!"metadata".equalsIgnoreCase(name)) continue;
                GephiReader.readWorkspaceMetadata(reader, workspace);
                continue;
            }
            if (!eventType.equals(2) || !"workspace".equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
        return workspace;
    }

    private static void readWorkspaceMetadata(XMLStreamReader reader, Workspace workspace) throws Exception {
        String property = null;
        while (reader.hasNext()) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                property = reader.getLocalName();
                continue;
            }
            if (eventType.equals(4)) {
                if (property != null && property.equals("description")) {
                    String desc = reader.getText();
                    workspace.getWorkspaceMetadata().setDescription(desc);
                    continue;
                }
                if (property == null || !property.equals("title")) continue;
                String title = reader.getText();
                workspace.getWorkspaceMetadata().setTitle(title);
                continue;
            }
            if (!eventType.equals(2) || !"metadata".equalsIgnoreCase(reader.getLocalName())) continue;
            return;
        }
    }

    private static void readProjectMetadata(XMLStreamReader reader, ProjectImpl project) throws Exception {
        String property = null;
        while (reader.hasNext()) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                property = reader.getLocalName();
                continue;
            }
            if (eventType.equals(4)) {
                if (property == null) continue;
                switch (property) {
                    case "title": {
                        project.getProjectMetadata().setTitle(reader.getText());
                        break;
                    }
                    case "author": {
                        project.getProjectMetadata().setAuthor(reader.getText());
                        break;
                    }
                    case "description": {
                        project.getProjectMetadata().setDescription(reader.getText());
                        break;
                    }
                    case "keywords": {
                        project.getProjectMetadata().setKeywords(reader.getText());
                    }
                }
                continue;
            }
            if (!eventType.equals(2) || !"metadata".equalsIgnoreCase(reader.getLocalName())) continue;
            return;
        }
    }

    public static void readWorkspaceChildren(Workspace workspace, XMLStreamReader reader, WorkspaceXMLPersistenceProvider persistenceProvider) throws Exception {
        String identifier = persistenceProvider.getIdentifier();
        boolean end = false;
        while (reader.hasNext() && !end) {
            Integer eventType = reader.next();
            if (eventType.equals(1)) {
                String name = reader.getLocalName();
                if (!identifier.equals(name)) continue;
                try {
                    persistenceProvider.readXML(reader, workspace);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            if (!eventType.equals(2) || !identifier.equalsIgnoreCase(reader.getLocalName())) continue;
            end = true;
        }
    }
}

