/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin.spreadsheet.wizard;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.ImporterSpreadsheetCSV;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.AbstractWizardVisualPanel1;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.ImportModeWrapper;
import org.gephi.ui.importer.plugin.spreadsheet.wizard.WizardPanel1CSV;
import org.gephi.utils.CharsetToolkit;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.NbBundle;

public class WizardVisualPanel1CSV
extends AbstractWizardVisualPanel1 {
    private final ImporterSpreadsheetCSV importer;
    private final WizardPanel1CSV wizard1;
    private ValidationPanel validationPanel;
    private boolean initialized = false;
    private JComboBox charsetComboBox;
    private JLabel charsetLabel;
    private JLabel filePathLabel;
    private JComboBox modeComboBox;
    private JLabel modeLabel;
    private JTextField pathTextField;
    private JLabel previewLabel;
    private JTable previewTable;
    private JScrollPane scroll;
    private JComboBox separatorComboBox;
    private JLabel separatorLabel;

    public WizardVisualPanel1CSV(ImporterSpreadsheetCSV importer, WizardPanel1CSV wizard1) {
        super((AbstractImporterSpreadsheet)importer);
        this.initComponents();
        this.wizard1 = wizard1;
        this.importer = importer;
        SeparatorWrapper comma = new SeparatorWrapper(Character.valueOf(','), this.getMessage("WizardVisualPanel1CSV.comma"));
        this.separatorComboBox.addItem(comma);
        SeparatorWrapper semicolon = new SeparatorWrapper(Character.valueOf(';'), this.getMessage("WizardVisualPanel1CSV.semicolon"));
        this.separatorComboBox.addItem(semicolon);
        SeparatorWrapper tab = new SeparatorWrapper(Character.valueOf('\t'), this.getMessage("WizardVisualPanel1CSV.tab"));
        this.separatorComboBox.addItem(tab);
        SeparatorWrapper space = new SeparatorWrapper(Character.valueOf(' '), this.getMessage("WizardVisualPanel1CSV.space"));
        this.separatorComboBox.addItem(space);
        for (SpreadsheetGeneralConfiguration.Mode mode : SpreadsheetGeneralConfiguration.Mode.values()) {
            this.modeComboBox.addItem(new ImportModeWrapper(mode));
        }
        for (Charset charset : CharsetToolkit.getAvailableCharsets()) {
            this.charsetComboBox.addItem(charset.name());
        }
        char c = importer.getFieldDelimiter();
        switch (c) {
            case ',': {
                this.separatorComboBox.setSelectedItem(comma);
                break;
            }
            case ';': {
                this.separatorComboBox.setSelectedItem(semicolon);
                break;
            }
            case '\t': {
                this.separatorComboBox.setSelectedItem(tab);
                break;
            }
            case ' ': {
                this.separatorComboBox.setSelectedItem(space);
                break;
            }
            default: {
                this.separatorComboBox.setSelectedItem(String.valueOf(c));
            }
        }
        this.modeComboBox.setSelectedItem(new ImportModeWrapper(importer.getMode()));
        Charset selectedCharset = importer.getCharset();
        if (selectedCharset != null) {
            this.charsetComboBox.setSelectedItem(selectedCharset.name());
        } else {
            this.charsetComboBox.setSelectedItem(StandardCharsets.UTF_8.name());
        }
        String filePath = importer.getFile().getAbsolutePath();
        this.pathTextField.setText(filePath);
        this.pathTextField.setToolTipText(filePath);
        this.initialized = true;
        this.refreshPreviewTable();
    }

    public ValidationPanel getValidationPanel() {
        if (this.validationPanel != null) {
            return this.validationPanel;
        }
        this.validationPanel = new ValidationPanel();
        this.validationPanel.setInnerComponent((Component)this);
        ValidationGroup validationGroup = this.validationPanel.getValidationGroup();
        validationGroup.add((Object)this.pathTextField, (Validator)new Validator<String>(){

            public Class<String> modelType() {
                return String.class;
            }

            public void validate(Problems prblms, String string, String t) {
                if (!WizardVisualPanel1CSV.this.areValidColumnsForTable()) {
                    prblms.add(WizardVisualPanel1CSV.this.getMessage("WizardVisualPanel1CSV.validation.edges.no-source-target-columns"));
                }
                if (WizardVisualPanel1CSV.this.hasRowsMissingSourcesOrTargets()) {
                    prblms.add(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.validation.edges.empty-sources-or-targets"), Severity.WARNING);
                }
            }
        });
        this.validationPanel.setName(this.getName());
        return this.validationPanel;
    }

    @Override
    public final void refreshPreviewTable() {
        super.refreshPreviewTable();
        this.wizard1.fireChangeEvent();
        this.pathTextField.setText(this.pathTextField.getText());
    }

    @Override
    public String getName() {
        return this.getMessage("WizardVisualPanel1CSV.name");
    }

    public Character getSelectedSeparator() {
        Object item = this.separatorComboBox.getSelectedItem();
        if (item instanceof SeparatorWrapper) {
            return ((SeparatorWrapper)item).separator;
        }
        String separatorString = item.toString().trim();
        if (separatorString.isEmpty()) {
            separatorString = ",";
        }
        return Character.valueOf(separatorString.charAt(0));
    }

    @Override
    public SpreadsheetGeneralConfiguration.Mode getSelectedMode() {
        if (this.modeComboBox.getItemCount() == 0) {
            return SpreadsheetGeneralConfiguration.Mode.ADJACENCY_LIST;
        }
        return ((ImportModeWrapper)this.modeComboBox.getSelectedItem()).getMode();
    }

    public Charset getSelectedCharset() {
        return Charset.forName(this.charsetComboBox.getSelectedItem().toString());
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean hasColumns() {
        return this.columnCount > 0;
    }

    public boolean areValidColumnsForTable() {
        switch (this.getSelectedMode()) {
            case EDGES_TABLE: {
                return this.hasSourceNodeColumn && this.hasTargetNodeColumn;
            }
            case NODES_TABLE: {
                return this.hasColumns();
            }
        }
        return true;
    }

    public boolean isValidData() {
        return this.areValidColumnsForTable();
    }

    public boolean hasRowsMissingSourcesOrTargets() {
        return this.hasRowsMissingSourcesOrTargets;
    }

    @Override
    protected JTable getPreviewTable() {
        return this.previewTable;
    }

    @Override
    protected JScrollPane getPreviewTableScrollPane() {
        return this.scroll;
    }

    private String getMessage(String resName) {
        return NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)resName);
    }

    private void initComponents() {
        this.filePathLabel = new JLabel();
        this.pathTextField = new JTextField();
        this.separatorLabel = new JLabel();
        this.separatorComboBox = new JComboBox();
        this.modeLabel = new JLabel();
        this.modeComboBox = new JComboBox();
        this.previewLabel = new JLabel();
        this.scroll = new JScrollPane();
        this.previewTable = new JTable();
        this.charsetLabel = new JLabel();
        this.charsetComboBox = new JComboBox();
        this.filePathLabel.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.filePathLabel.text"));
        this.pathTextField.setEditable(false);
        this.pathTextField.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.pathTextField.text"));
        this.separatorLabel.setHorizontalAlignment(0);
        this.separatorLabel.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.separatorLabel.text"));
        this.separatorComboBox.setEditable(true);
        this.separatorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WizardVisualPanel1CSV.this.separatorComboBoxItemStateChanged(evt);
            }
        });
        this.modeLabel.setHorizontalAlignment(0);
        this.modeLabel.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.modeLabel.text"));
        this.modeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WizardVisualPanel1CSV.this.modeComboBoxItemStateChanged(evt);
            }
        });
        this.previewLabel.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.previewLabel.text"));
        this.previewTable.setAutoResizeMode(0);
        this.scroll.setViewportView(this.previewTable);
        this.charsetLabel.setHorizontalAlignment(0);
        this.charsetLabel.setText(NbBundle.getMessage(WizardVisualPanel1CSV.class, (String)"WizardVisualPanel1CSV.charsetLabel.text"));
        this.charsetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WizardVisualPanel1CSV.this.charsetComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scroll, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addComponent(this.filePathLabel, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.separatorLabel, -1, -1, Short.MAX_VALUE).addComponent(this.separatorComboBox, 0, 90, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.modeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.modeComboBox, 0, 123, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.charsetLabel, -1, 308, Short.MAX_VALUE).addComponent(this.charsetComboBox, 0, 308, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.previewLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.pathTextField, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.separatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separatorComboBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modeLabel).addComponent(this.charsetLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modeComboBox, -2, -1, -2).addComponent(this.charsetComboBox, -2, -1, -2)))).addGap(18, 18, 18).addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 150, Short.MAX_VALUE).addContainerGap()));
    }

    private void separatorComboBoxItemStateChanged(ItemEvent evt) {
        if (this.initialized) {
            String separatorString;
            Object item = this.separatorComboBox.getSelectedItem();
            if (!(item instanceof SeparatorWrapper) && (separatorString = item.toString().trim()).length() > 1) {
                this.separatorComboBox.setSelectedItem(separatorString.substring(0, 1));
            }
            this.importer.setFieldDelimiter(this.getSelectedSeparator().charValue());
            this.refreshPreviewTable();
        }
    }

    private void charsetComboBoxItemStateChanged(ItemEvent evt) {
        if (this.initialized) {
            this.importer.setCharset(this.getSelectedCharset());
            this.refreshPreviewTable();
        }
    }

    private void modeComboBoxItemStateChanged(ItemEvent evt) {
        if (this.initialized) {
            this.importer.setMode(this.getSelectedMode());
            this.refreshPreviewTable();
        }
    }

    class SeparatorWrapper {
        private final Character separator;
        private String displayText;

        public SeparatorWrapper(Character separator) {
            this.separator = separator;
        }

        public SeparatorWrapper(Character separator, String displayText) {
            this.separator = separator;
            this.displayText = displayText;
        }

        public String toString() {
            if (this.displayText != null) {
                return this.displayText;
            }
            return String.valueOf(this.separator);
        }
    }
}

