/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Set;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.AttributeColumnPropertyEditor;
import org.gephi.filters.FilterModelImpl;
import org.gephi.filters.FilterProcessor;
import org.gephi.filters.FilterQueryImpl;
import org.gephi.filters.FilterThread;
import org.gephi.filters.GenericPropertyEditor;
import org.gephi.filters.OperatorQueryImpl;
import org.gephi.filters.RangePropertyEditor;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterModel;
import org.gephi.filters.api.PropertyExecutor;
import org.gephi.filters.api.Query;
import org.gephi.filters.api.Range;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.ElementFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.spi.Controller;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FilterControllerImpl
implements FilterController,
PropertyExecutor,
Controller<FilterModelImpl> {
    public FilterControllerImpl() {
        PropertyEditorManager.registerEditor(Range.class, RangePropertyEditor.class);
        PropertyEditorManager.registerEditor(Column.class, AttributeColumnPropertyEditor.class);
        PropertyEditorManager.registerEditor(Set.class, GenericPropertyEditor.class);
        PropertyEditorManager.registerEditor(Number.class, GenericPropertyEditor.class);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
                FilterModelImpl m = (FilterModelImpl)workspace.getLookup().lookup(FilterModel.class);
                if (m != null) {
                    m.destroy();
                    if (m.getCurrentResult() != null && m.getGraphModel() != null) {
                        m.getGraphModel().destroyView(m.getCurrentResult());
                        m.setCurrentResult(null);
                    }
                }
            }

            public void disable() {
            }
        });
    }

    public FilterModelImpl newModel(Workspace workspace) {
        return new FilterModelImpl(workspace);
    }

    public Class<FilterModelImpl> getModelClass() {
        return FilterModelImpl.class;
    }

    public FilterModelImpl getModel(Workspace workspace) {
        return (FilterModelImpl)super.getModel(workspace);
    }

    public FilterModelImpl getModel() {
        return (FilterModelImpl)super.getModel();
    }

    public Query createQuery(FilterBuilder builder) {
        Filter filter = builder.getFilter(this.getModel().getWorkspace());
        if (filter instanceof Operator) {
            return new OperatorQueryImpl((Operator)filter);
        }
        return new FilterQueryImpl(builder, filter);
    }

    public Query createQuery(Filter filter) {
        if (filter instanceof Operator) {
            return new OperatorQueryImpl((Operator)filter);
        }
        return new FilterQueryImpl(null, filter);
    }

    public void add(Query query) {
        FilterModelImpl model = this.getModel();
        AbstractQueryImpl absQuery = (AbstractQueryImpl)query;
        if (!model.hasQuery(absQuery = absQuery.getRoot())) {
            Graph graph;
            model.addFirst(absQuery);
            if (model.getGraphModel() != null) {
                graph = model.getGraphModel().getGraph();
            } else {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(model.getWorkspace());
                graph = graphModel.getGraph();
            }
            for (Query q : query.getDescendantsAndSelf()) {
                Filter filter = q.getFilter();
                if (!(filter instanceof NodeFilter) && !(filter instanceof EdgeFilter) && !(filter instanceof ElementFilter)) continue;
                FilterProcessor filterProcessor = new FilterProcessor();
                filterProcessor.init(filter, graph);
            }
        }
    }

    public void remove(Query query) {
        FilterModelImpl model = this.getModel();
        if (model.getCurrentQuery() == query) {
            if (model.isSelecting()) {
                this.selectVisible(null);
            } else {
                this.filterVisible(null);
            }
        }
        query = ((AbstractQueryImpl)query).getRoot();
        model.remove(query);
    }

    public void rename(Query query, String name) {
        FilterModelImpl model = this.getModel();
        model.rename(query, name);
    }

    public void setSubQuery(Query query, Query subQuery) {
        FilterModelImpl model = this.getModel();
        if (subQuery.getParent() == null && subQuery != model.getCurrentQuery()) {
            Graph graph;
            if (model != null && model.getGraphModel() != null) {
                graph = model.getGraphModel().getGraph();
            } else {
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(model.getWorkspace());
                graph = graphModel.getGraph();
            }
            Filter filter = subQuery.getFilter();
            if (filter instanceof NodeFilter || filter instanceof EdgeFilter || filter instanceof ElementFilter) {
                FilterProcessor filterProcessor = new FilterProcessor();
                filterProcessor.init(filter, graph);
            }
        }
        model.setSubQuery(query, subQuery);
    }

    public void removeSubQuery(Query query, Query parent) {
        this.getModel().removeSubQuery(query, parent);
    }

    public void filterVisible(Query query) {
        FilterModelImpl model = this.getModel();
        if (query != null && model.getCurrentQuery() == query && model.isFiltering()) {
            return;
        }
        model.setFiltering(query != null);
        model.setCurrentQuery(query);
        if (model.getFilterThread() != null) {
            model.getFilterThread().setRunning(false);
            model.setFilterThread(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(model);
            model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            model.getGraphModel().setVisibleView(null);
            if (model.getCurrentResult() != null) {
                model.getGraphModel().destroyView(model.getCurrentResult());
                model.setCurrentResult(null);
            }
        }
    }

    public GraphView filter(Query query) {
        FilterModelImpl model = this.getModel();
        FilterProcessor processor = new FilterProcessor();
        GraphModel graphModel = model.getGraphModel();
        Graph result = processor.process((AbstractQueryImpl)query, graphModel);
        return result.getView();
    }

    public void selectVisible(Query query) {
        FilterModelImpl model = this.getModel();
        if (query != null && model.getCurrentQuery() == query && model.isSelecting()) {
            return;
        }
        model.setSelecting(query != null);
        model.setCurrentQuery(query);
        if (model.getFilterThread() != null) {
            model.getFilterThread().setRunning(false);
            model.setFilterThread(null);
        }
        model.getGraphModel().setVisibleView(null);
        if (model.getCurrentResult() != null) {
            model.getGraphModel().destroyView(model.getCurrentResult());
            model.setCurrentResult(null);
        }
        if (query != null) {
            FilterThread filterThread = new FilterThread(model);
            model.setFilterThread(filterThread);
            filterThread.setRootQuery((AbstractQueryImpl)query);
            filterThread.start();
        } else {
            VisualizationController visController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
            if (visController != null) {
                visController.resetSelection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToColumn(String title, Query query) {
        Column edgeCol;
        Subgraph result;
        FilterModelImpl model = this.getModel();
        if (model.getCurrentQuery() == query) {
            GraphView view = model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = model.getGraphModel();
            result = processor.process((AbstractQueryImpl)query, graphModel);
        }
        Column nodeCol = result.getModel().getNodeTable().getColumn("filter_" + title);
        if (nodeCol == null) {
            nodeCol = result.getModel().getNodeTable().addColumn("filter_" + title, title, Boolean.class, Origin.DATA, (Object)Boolean.FALSE, true);
        }
        if ((edgeCol = result.getModel().getEdgeTable().getColumn("filter_" + title)) == null) {
            edgeCol = result.getModel().getEdgeTable().addColumn("filter_" + title, title, Boolean.class, Origin.DATA, (Object)Boolean.FALSE, true);
        }
        result.writeLock();
        try {
            for (Node n : result.getNodes()) {
                n.setAttribute(nodeCol, (Object)Boolean.TRUE);
            }
            for (Edge e : result.getEdges()) {
                e.setAttribute(edgeCol, (Object)Boolean.TRUE);
            }
        }
        finally {
            result.writeUnlock();
            result.readUnlockAll();
        }
    }

    public void exportToNewWorkspace(Query query) {
        Subgraph result;
        FilterModelImpl model = this.getModel();
        if (model.getCurrentQuery() == query) {
            GraphView view = model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            GraphModel graphModel = model.getGraphModel();
            result = processor.process((AbstractQueryImpl)query, graphModel);
        }
        Subgraph graphView = result;
        new Thread(new Runnable((Graph)graphView){
            final /* synthetic */ Graph val$graphView;
            {
                this.val$graphView = graph;
            }

            @Override
            public void run() {
                ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
                ProgressTicket ticket = null;
                if (progressProvider != null) {
                    String msg = NbBundle.getMessage(FilterControllerImpl.class, (String)"FilterController.exportToNewWorkspace.task");
                    ticket = progressProvider.createTicket(msg, null);
                }
                Progress.start(ticket);
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                Workspace newWorkspace = pc.newWorkspace(pc.getCurrentProject());
                GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(newWorkspace);
                graphModel.setConfiguration(this.val$graphView.getModel().getConfiguration());
                graphModel.bridge().copyNodes(this.val$graphView.getNodes().toArray());
                Graph graph = graphModel.getGraph();
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                for (Edge edge : graph.getEdges()) {
                    if (this.val$graphView.hasEdge(edge.getId())) continue;
                    edgesToRemove.add(edge);
                }
                if (!edgesToRemove.isEmpty()) {
                    graph.removeAllEdges(edgesToRemove);
                }
                Progress.finish((ProgressTicket)ticket);
                String workspaceName = ((WorkspaceInformation)newWorkspace.getLookup().lookup(WorkspaceInformation.class)).getName();
            }
        }, "Export filter to workspace").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToLabelVisible(Query query) {
        Subgraph result;
        FilterModelImpl model = this.getModel();
        if (model.getCurrentQuery() == query) {
            GraphView view = model.getCurrentResult();
            if (view == null) {
                return;
            }
            result = model.getGraphModel().getGraph(view);
        } else {
            FilterProcessor processor = new FilterProcessor();
            result = processor.process((AbstractQueryImpl)query, model.getGraphModel());
        }
        Graph fullGraph = model.getGraphModel().getGraph();
        fullGraph.writeLock();
        try {
            boolean inView;
            for (Node n : fullGraph.getNodes()) {
                inView = result.contains(n);
                n.getTextProperties().setVisible(inView);
            }
            for (Edge e : fullGraph.getEdges()) {
                inView = result.contains(e);
                e.getTextProperties().setVisible(inView);
            }
        }
        finally {
            fullGraph.writeUnlock();
            fullGraph.readUnlockAll();
        }
    }

    public void setAutoRefresh(boolean autoRefresh) {
        FilterModelImpl model = this.getModel();
        if (model != null) {
            model.setAutoRefresh(autoRefresh);
        }
    }

    public void setCurrentQuery(Query query) {
        FilterModelImpl model = this.getModel();
        if (model != null) {
            model.setCurrentQuery(query);
        }
    }

    public void setValue(FilterProperty property, Object value, PropertyExecutor.Callback callback) {
        FilterModelImpl model = this.getModel();
        if (model != null) {
            Query query = model.getQuery(property.getFilter());
            if (query == null) {
                callback.setValue(value);
                return;
            }
            AbstractQueryImpl rootQuery = ((AbstractQueryImpl)query).getRoot();
            FilterThread filterThread = model.getFilterThread();
            if (filterThread != null && model.getCurrentQuery() == rootQuery) {
                if (Thread.currentThread().equals(filterThread)) {
                    callback.setValue(value);
                    model.updateParameters(query);
                } else {
                    filterThread.addModifier(new FilterThread.PropertyModifier(query, property, value, callback));
                    filterThread.setRootQuery(rootQuery);
                }
            } else {
                callback.setValue(value);
                model.updateParameters(query);
            }
        } else {
            callback.setValue(value);
        }
    }
}

