/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.gradientslider;

import com.bric.swing.ColorPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.gephi.ui.components.gradientslider.MultiThumbSlider;
import org.gephi.ui.components.gradientslider.MultiThumbSliderUI;

public class GradientSlider
extends MultiThumbSlider {
    private static final long serialVersionUID = 1L;
    JPopupMenu popup;

    public GradientSlider() {
        this(0);
    }

    public GradientSlider(int orientation) {
        this(orientation, new float[]{0.0f, 1.0f}, new Color[]{Color.white, Color.black});
    }

    public GradientSlider(int orientation, float[] thumbPositions, Color[] values) {
        super(orientation, thumbPositions, values);
    }

    private static Color tween(Color c1, Color c2, float p) {
        return new Color((int)((float)c1.getRed() * (1.0f - p) + (float)c2.getRed() * p), (int)((float)c1.getGreen() * (1.0f - p) + (float)c2.getGreen() * p), (int)((float)c1.getBlue() * (1.0f - p) + (float)c2.getBlue() * p), (int)((float)c1.getAlpha() * (1.0f - p) + (float)c2.getAlpha() * p));
    }

    @Override
    public Object getValue(float pos) {
        for (int a = 0; a < this.thumbPositions.length - 1; ++a) {
            if (this.thumbPositions[a] == pos) {
                return this.values[a];
            }
            if (!(this.thumbPositions[a] < pos) || !(pos < this.thumbPositions[a + 1])) continue;
            float v = (pos - this.thumbPositions[a]) / (this.thumbPositions[a + 1] - this.thumbPositions[a]);
            return GradientSlider.tween((Color)this.values[a], (Color)this.values[a + 1], v);
        }
        if (pos < this.thumbPositions[0]) {
            return this.values[0];
        }
        if (pos > this.thumbPositions[this.thumbPositions.length - 1]) {
            return this.values[this.values.length - 1];
        }
        return null;
    }

    public Color[] getColors() {
        Color[] c = new Color[this.values.length];
        for (int a = 0; a < c.length; ++a) {
            c[a] = (Color)this.values[a];
        }
        return c;
    }

    @Override
    public boolean doDoubleClick(int x, int y) {
        int i = this.getSelectedThumb();
        if (i != -1) {
            this.showColorPicker();
            SwingUtilities.invokeLater(new SelectThumbRunnable(i));
            return true;
        }
        return false;
    }

    private JPopupMenu createPopup() {
        return new ColorPickerPopup();
    }

    @Override
    public boolean doPopup(int x, int y) {
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        this.popup.show(this, x, y);
        return true;
    }

    private Frame getFrame() {
        Window w = SwingUtilities.getWindowAncestor(this);
        if (w instanceof Frame) {
            return (Frame)w;
        }
        return null;
    }

    private boolean showColorPicker() {
        Object[] colors = this.getColors();
        int i = this.getSelectedThumb();
        Frame frame = this.getFrame();
        boolean includeOpacity = MultiThumbSliderUI.getProperty(this, "GradientSlider.includeOpacity", "true").equals("true");
        colors[i] = ColorPicker.showDialog((Window)frame, (Color)colors[i], (boolean)includeOpacity);
        if (colors[i] != null) {
            this.setValues(this.getThumbPositions(), colors);
        }
        return true;
    }

    private void showJColorChooser() {
        Object[] colors = this.getColors();
        int i = this.getSelectedThumb();
        if (i >= 0 && i < colors.length) {
            colors[i] = JColorChooser.showDialog(this, "Choose a Color", colors[i]);
            if (colors[i] != null) {
                this.setValues(this.getThumbPositions(), colors);
            }
        }
    }

    @Override
    public void updateUI() {
        String name = UIManager.getString("GradientSliderUI");
        try {
            Class<?> c = Class.forName(name);
            Constructor<?>[] constructors = c.getConstructors();
            for (int a = 0; a < constructors.length; ++a) {
                Class<?>[] types = constructors[a].getParameterTypes();
                if (types.length != 1 || !types[0].equals(GradientSlider.class)) continue;
                ComponentUI ui = (ComponentUI)constructors[a].newInstance(this);
                this.setUI(ui);
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class \"" + name + "\" could not be found.");
        }
        catch (Throwable t) {
            RuntimeException e = new RuntimeException("The class \"" + name + "\" could not be constructed.", t);
            throw e;
        }
    }

    static {
        if (UIManager.getString("GradientSliderUI") == null) {
            UIManager.put("GradientSliderUI", "org.gephi.ui.components.gradientslider.GradientSliderUI");
        }
    }

    class ColorPickerPopup
    extends AbstractPopup {
        private static final long serialVersionUID = 1L;
        ColorPicker mini;
        KeyListener commitListener;

        public ColorPickerPopup() {
            this.commitListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                        ColorPickerPopup.this.setVisible(false);
                    }
                }
            };
            boolean includeOpacity = MultiThumbSliderUI.getProperty(GradientSlider.this, "GradientSlider.includeOpacity", "true").equals("true");
            this.mini = new ColorPicker(false, includeOpacity);
            this.mini.setMode(0);
            this.mini.setPreferredSize(new Dimension(220, 200));
            PropertyChangeListener p = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ColorPicker p = (ColorPicker)evt.getSource();
                    Object[] colors = GradientSlider.this.getColors();
                    colors[ColorPickerPopup.this.lastSelectedThumb] = p.getColor();
                    GradientSlider.this.setValues(GradientSlider.this.getThumbPositions(), colors);
                }
            };
            this.mini.addPropertyChangeListener("selected color", p);
            this.mini.addPropertyChangeListener("opacity", p);
            for (int a = 0; a < this.mini.getComponentCount(); ++a) {
                Component c = this.mini.getComponent(a);
                c.addKeyListener(this.commitListener);
            }
            this.add((Component)this.mini);
        }

        @Override
        public Component getFocusableComponent() {
            return this.mini.getColorPanel();
        }

        @Override
        public void setColor(Color c) {
            this.mini.setRGB(c.getRed(), c.getGreen(), c.getBlue());
        }
    }

    abstract class AbstractPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        int lastSelectedThumb;
        PopupMenuListener popupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                GradientSlider.this.setValueIsAdjusting(false);
                SwingUtilities.invokeLater(new SelectThumbRunnable(AbstractPopup.this.lastSelectedThumb));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GradientSlider.this.setValueIsAdjusting(false);
                SwingUtilities.invokeLater(new SelectThumbRunnable(AbstractPopup.this.lastSelectedThumb));
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GradientSlider.this.setValueIsAdjusting(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractPopup.this.getFocusableComponent().requestFocus();
                    }
                });
            }
        };

        public AbstractPopup() {
            this.addPopupMenuListener(this.popupMenuListener);
        }

        public abstract Component getFocusableComponent();

        @Override
        public void show(Component c, int x, int y) {
            Color[] colors = GradientSlider.this.getColors();
            this.lastSelectedThumb = GradientSlider.this.getSelectedThumb();
            if (this.lastSelectedThumb != -1) {
                this.setColor(colors[this.lastSelectedThumb]);
                super.show(c, x, y);
            }
        }

        public abstract void setColor(Color var1);
    }

    class SelectThumbRunnable
    implements Runnable {
        int index;

        public SelectThumbRunnable(int i) {
            this.index = i;
        }

        @Override
        public void run() {
            GradientSlider.this.setSelectedThumb(this.index);
        }
    }
}

