/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import org.gephi.preview.AbstractRenderTarget;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.Vector;
import org.gephi.preview.spi.RenderTargetBuilder;
import org.openide.util.Lookup;

public class G2DRenderTargetBuilder
implements RenderTargetBuilder {
    @Override
    public RenderTarget buildRenderTarget(PreviewModel previewModel) {
        Integer width = (Integer)previewModel.getProperties().getValue("width");
        Integer height = (Integer)previewModel.getProperties().getValue("height");
        if (width != null && height != null) {
            width = Math.max(1, width);
            height = Math.max(1, height);
            return new G2DTargetImpl(previewModel, width, height);
        }
        return new G2DTargetImpl(previewModel, 1, 1);
    }

    @Override
    public String getName() {
        return "g2d";
    }

    public static class G2DGraphics {
        private final PreviewController previewController = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        private final Image image;
        private final int width;
        private final int height;
        private final Graphics2D g2;
        private final Vector trans = new Vector();
        private boolean inited;
        private float scaling;
        private Color background = Color.WHITE;

        public G2DGraphics(int width, int height) {
            this.width = width;
            this.height = height;
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.image = graphicsConfiguration.createCompatibleImage(width, height, 3);
            this.g2 = (Graphics2D)this.image.getGraphics();
            this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            this.g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }

        public void refresh(PreviewModel m, RenderTarget target) {
            if (m == null) {
                return;
            }
            if (!this.inited && m.getGraphicsCanvasSize() != null) {
                CanvasSize cs = this.getSheetCanvasSize(m);
                this.scaling = this.computeDefaultScaling(cs);
                this.fit(cs);
                this.inited = true;
            }
            this.g2.setTransform(new AffineTransform());
            this.background = m.getProperties().getColorValue("background-color");
            if (this.background != null) {
                this.g2.setColor(this.background);
                this.g2.fillRect(0, 0, this.width, this.height);
            }
            Vector center = new Vector((float)this.width / 2.0f, (float)this.height / 2.0f);
            Vector scaledCenter = Vector.mult(center, this.scaling);
            Vector scaledTrans = Vector.sub(center, scaledCenter);
            this.g2.translate(scaledTrans.x, scaledTrans.y);
            this.g2.scale(this.scaling, this.scaling);
            this.g2.translate(this.trans.x, this.trans.y);
            this.previewController.render(target);
        }

        public Vector getTranslate() {
            return this.trans;
        }

        public float getScaling() {
            return this.scaling;
        }

        public void setScaling(float scaling) {
            this.scaling = scaling;
        }

        public Graphics2D getGraphics() {
            return this.g2;
        }

        public Image getImage() {
            return this.image;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void reset() {
            this.inited = false;
        }

        private CanvasSize getSheetCanvasSize(PreviewModel m) {
            CanvasSize cs = m.getGraphicsCanvasSize();
            float marginPercentage = m.getProperties().getFloatValue("margin");
            float marginWidth = cs.getWidth() * marginPercentage / 100.0f;
            float marginHeight = cs.getHeight() * marginPercentage / 100.0f;
            return new CanvasSize(cs.getX() - marginWidth, cs.getY() - marginHeight, cs.getWidth() + 2.0f * marginWidth, cs.getHeight() + 2.0f * marginHeight);
        }

        private float computeDefaultScaling(CanvasSize cs) {
            float ratioHeight;
            float ratioWidth = (float)this.width / cs.getWidth();
            return ratioWidth < (ratioHeight = (float)this.height / cs.getHeight()) ? ratioWidth : ratioHeight;
        }

        private void fit(CanvasSize cs) {
            Vector box = new Vector(cs.getWidth(), cs.getHeight());
            Vector semiBox = Vector.div(box, 2.0f);
            Vector topLeft = new Vector(cs.getX(), cs.getY());
            Vector center = new Vector((float)this.width / 2.0f, (float)this.height / 2.0f);
            Vector scaledCenter = Vector.add(topLeft, semiBox);
            this.trans.set(center);
            this.trans.sub(scaledCenter);
        }
    }

    public static class G2DTargetImpl
    extends AbstractRenderTarget
    implements G2DTarget {
        private final PreviewModel previewModel;
        private G2DGraphics graphics;

        public G2DTargetImpl(PreviewModel model, int width, int height) {
            this.graphics = new G2DGraphics(width, height);
            this.previewModel = model;
        }

        @Override
        public void resize(int width, int height) {
            width = Math.max(1, width);
            height = Math.max(1, height);
            this.graphics.getGraphics().dispose();
            this.graphics = new G2DGraphics(width, height);
        }

        @Override
        public Graphics2D getGraphics() {
            return this.graphics.getGraphics();
        }

        @Override
        public Image getImage() {
            return this.graphics.getImage();
        }

        @Override
        public int getWidth() {
            return this.graphics.getWidth();
        }

        @Override
        public int getHeight() {
            return this.graphics.getHeight();
        }

        @Override
        public Vector getTranslate() {
            return this.graphics.getTranslate();
        }

        @Override
        public float getScaling() {
            return this.graphics.getScaling();
        }

        @Override
        public void setScaling(float scaling) {
            this.graphics.setScaling(scaling);
        }

        @Override
        public void setMoving(boolean moving) {
            this.previewModel.getProperties().putValue("canvas.moving", moving);
        }

        @Override
        public void reset() {
            this.graphics.reset();
        }

        @Override
        public synchronized void refresh() {
            if (this.graphics != null) {
                this.graphics.refresh(this.previewModel, this);
            }
        }
    }
}

