/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.search.filter;

import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.desktop.search.api.SearchCategory;
import org.gephi.desktop.search.filter.SearchFilterBuilder;
import org.gephi.desktop.search.impl.SearchCategoryImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SearchPanel
extends JPanel {
    private JButton searchButton;
    private JTextField searchField;
    private JLabel searchInLabel;
    private JComboBox<SearchCategory> typeCombo;

    public SearchPanel() {
        this.initComponents();
        DefaultComboBoxModel<SearchCategory> comboBoxModel = new DefaultComboBoxModel<SearchCategory>();
        comboBoxModel.addElement(SearchCategoryImpl.NODES());
        comboBoxModel.addElement(SearchCategoryImpl.EDGES());
        this.typeCombo.setModel(comboBoxModel);
        this.typeCombo.setSelectedIndex(0);
    }

    public void setup(SearchFilterBuilder.SearchFilter filter) {
        this.searchField.setText(filter.getQuery());
        this.typeCombo.setSelectedItem(SearchCategory.findById(filter.getType()));
        this.searchButton.addActionListener(evt -> {
            filter.getProperties()[0].setValue((Object)this.searchField.getText());
            filter.getProperties()[1].setValue((Object)((SearchCategory)this.typeCombo.getSelectedItem()).getId());
        });
    }

    private void initComponents() {
        this.searchField = new JTextField();
        this.typeCombo = new JComboBox();
        this.searchButton = new JButton();
        this.searchInLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.searchInLabel, (String)NbBundle.getMessage(SearchPanel.class, (String)"SearchPanel.searchInLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.searchInLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeCombo, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.searchField, -1, 161, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchInLabel).addComponent(this.typeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

