/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: HttpPostDataAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/08/05 10:39:42 $
 *****************************************************************************/
package org.ten60.netkernel.ext_install.installer;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.util.*;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.util.Utils;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.Version;

import java.net.*;
import java.io.*;
import java.util.*;
import org.w3c.dom.*;
/**
 *	Process dependencies needed on adding new modules
 * @author  tab
 */
public class HttpPostDataAccessor extends XAccessor
{
	public HttpPostDataAccessor()
	{	declareArgument(XAccessor.OPERAND, true, false); // uri to post to
		declareArgument(XAccessor.PARAMETER, true, false); // data to post
	}
	

	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		URI postURI = aHelper.getURI(XAHelper.OPERAND);
		HttpURLConnection urlcon=(HttpURLConnection)postURI.toURL().openConnection();
		urlcon.setRequestMethod("POST");
		urlcon.setDoOutput(true);
		urlcon.setDoInput(true);
		IURRepresentation rep=aHelper.getParameter(IAspectBinaryStream.class);
		IAspectBinaryStream bin = (IAspectBinaryStream)rep.getAspect(IAspectBinaryStream.class);
		urlcon.setRequestProperty("Content-Type", rep.getMeta().getMimeType()+"; "+bin.getEncoding());
		
		BufferedOutputStream bos=new BufferedOutputStream(urlcon.getOutputStream());
		urlcon.connect();
		bin.write(bos);
		bos.flush();
		bos.close();
		
		ByteArrayOutputStream baos=new ByteArrayOutputStream();
		BufferedInputStream is= new BufferedInputStream(urlcon.getInputStream());
		Utils.pipe(is, baos);
		IURMeta meta = new MetaImpl(urlcon.getContentType(), 0, 64);
		IURAspect aspect = new ByteArrayAspect(baos);
		return new MonoRepresentationImpl(meta,aspect);
	}
}